% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/spp_references.R
\name{spp_references}
\alias{spp_references}
\title{Get references for a given taxon concept}
\usage{
spp_references(
  taxon_id,
  raw = FALSE,
  token = NULL,
  verbose = TRUE,
  pause = 1,
  ...
)
}
\arguments{
\item{taxon_id}{a vector of character strings containing species' taxon
concept identifiers (see \code{\link[=spp_taxonconcept]{spp_taxonconcept()}}).}

\item{raw}{a logical. Should raw data be returned?}

\item{token}{a character string containing the authentification token, see
\url{https://api.speciesplus.net/documentation}. Default is set to
\code{NULL} and requires the environment variable \code{SPECIESPLUS_TOKEN} to be
set directly in \code{Renviron}. Alternatively, \code{\link[=set_token]{set_token()}} can be used to set
\code{SPECIESPLUS_TOKEN} for the current session.}

\item{verbose}{a logical. Should extra information be reported on progress?}

\item{pause}{a duration (in second) to suspend execution for (see
\code{\link[=Sys.sleep]{Sys.sleep()}}). This was added cause the web API returns a 404 error too many
requests in a short time interval.}

\item{...}{Further named parameters, see \code{\link[httr:GET]{httr::GET()}}.}
}
\value{
If \code{raw} is set to \code{TRUE} then an object of class \code{spp_raw} (or
\code{spp_raw_multi} if \code{length(taxon_id) > 1}) is returned which is essentially
a list of lists (see option \code{as = 'parsed'} in \code{\link[httr:content]{httr::content()}}).
Otherwise, an object of class \code{spp_refs} (or \code{spp_refs_multi} if
\code{length(taxon_id) > 1}) is returned which is a list of one
data frame:
\itemize{
\item \code{references} that includes the identifier of the reference and the
corresponding citation.
}
}
\description{
Retrieve available references for a given taxon concept.
}
\examples{
\donttest{
res1 <- spp_references(taxon_id = '4521')
res2 <- spp_references(c('4521', '3210', '10255'))
res3 <- spp_references(taxon_id = '4521', raw = TRUE, verbose = FALSE,
 config = httr::progress())
}
}
\references{
\url{https://api.speciesplus.net/documentation/v1/references/index.html}
}
