% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/display.r
\name{print_leaderboard}
\alias{print_leaderboard}
\title{Format the leaderboard in Markdown.}
\usage{
print_leaderboard(
  best,
  metrics = names(metrics),
  test_name = "quiz",
  digits = 3,
  ...
)
}
\arguments{
\item{best}{list of the best submissions per team and per metric as returned
by \code{\link{get_best}}.}

\item{metrics}{character vector. names of the metrics to be displayed}

\item{test_name}{string. name of the test set used: \code{"quiz"} or \code{"test"}}

\item{digits}{integer. how many significant digits are to be used for metrics.}

\item{...}{further parameters to pass to \code{\link[knitr]{kable}}}
}
\value{
\code{print_leaderboard} returns a character vector of the table source code
  to be used in a Markdown document.
}
\description{
Format the leaderboard in Markdown.
}
\note{
Chunk option \code{results='asis'} has to be used
}
\seealso{
\code{\link[knitr]{kable}}
}
