% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cdo-yseasavg.R, R/cdo-yseasmax.R,
%   R/cdo-yseasmean.R, R/cdo-yseasmin.R, R/cdo-yseasrange.R, R/cdo-yseasstd.R,
%   R/cdo-yseasstd1.R, R/cdo-yseassum.R, R/cdo-yseasvar.R, R/cdo-yseasvar1.R,
%   R/family-yseasstat.R
\name{cdo_yseasavg}
\alias{cdo_yseasavg}
\alias{cdo_yseasmax}
\alias{cdo_yseasmean}
\alias{cdo_yseasmin}
\alias{cdo_yseasrange}
\alias{cdo_yseasstd}
\alias{cdo_yseasstd1}
\alias{cdo_yseassum}
\alias{cdo_yseasvar}
\alias{cdo_yseasvar1}
\alias{yseasstat}
\title{Multiyear seasonal statistics}
\usage{
cdo_yseasavg(ifile, ofile = NULL)

cdo_yseasmax(ifile, ofile = NULL)

cdo_yseasmean(ifile, ofile = NULL)

cdo_yseasmin(ifile, ofile = NULL)

cdo_yseasrange(ifile, ofile = NULL)

cdo_yseasstd(ifile, ofile = NULL)

cdo_yseasstd1(ifile, ofile = NULL)

cdo_yseassum(ifile, ofile = NULL)

cdo_yseasvar(ifile, ofile = NULL)

cdo_yseasvar1(ifile, ofile = NULL)
}
\arguments{
\item{ifile}{String with the path to the input file.}

\item{ofile}{String with the path to the output file.}
}
\value{
Operators that output one or more files return a character vector to the
output files.

Operators that output an indefinite number of files return a string with the
basename of the files.

Operatos that don't return filenames return a character vector with the
string output.
}
\description{
This module computes statistical values of each season. Depending on the chosen operator the minimum, maximum, range, sum, average, variance or standard deviation of each season in infile is written to outfile. The date information in an output field is the date of the last contributing input field.
}
\details{
\if{html}{\out{<div class="sourceCode">}}\preformatted{yseasmin    Multi-year seasonal minimum
            o(1,x) = min\\\{i(t,x), month(i(t)) = 12, 01, 02\\\}
            o(2,x) = min\\\{i(t,x), month(i(t)) = 03, 04, 05\\\}
            o(3,x) = min\\\{i(t,x), month(i(t)) = 06, 07, 08\\\}
            o(4,x) = min\\\{i(t,x), month(i(t)) = 09, 10, 11\\\}
yseasmax    Multi-year seasonal maximum
            o(1,x) = max\\\{i(t,x), month(i(t)) = 12, 01, 02\\\}
            o(2,x) = max\\\{i(t,x), month(i(t)) = 03, 04, 05\\\}
            o(3,x) = max\\\{i(t,x), month(i(t)) = 06, 07, 08\\\}
            o(4,x) = max\\\{i(t,x), month(i(t)) = 09, 10, 11\\\}
yseasrange  Multi-year seasonal range
            o(1,x) = range\\\{i(t,x), month(i(t)) = 12, 01, 02\\\}
            o(2,x) = range\\\{i(t,x), month(i(t)) = 03, 04, 05\\\}
            o(3,x) = range\\\{i(t,x), month(i(t)) = 06, 07, 08\\\}
            o(4,x) = range\\\{i(t,x), month(i(t)) = 09, 10, 11\\\}
yseassum    Multi-year seasonal sum
            o(1,x) = sum\\\{i(t,x), month(i(t)) = 12, 01, 02\\\}
            o(2,x) = sum\\\{i(t,x), month(i(t)) = 03, 04, 05\\\}
            o(3,x) = sum\\\{i(t,x), month(i(t)) = 06, 07, 08\\\}
            o(4,x) = sum\\\{i(t,x), month(i(t)) = 09, 10, 11\\\}
yseasmean   Multi-year seasonal mean
            o(1,x) = mean\\\{i(t,x), month(i(t)) = 12, 01, 02\\\}
            o(2,x) = mean\\\{i(t,x), month(i(t)) = 03, 04, 05\\\}
            o(3,x) = mean\\\{i(t,x), month(i(t)) = 06, 07, 08\\\}
            o(4,x) = mean\\\{i(t,x), month(i(t)) = 09, 10, 11\\\}
yseasavg    Multi-year seasonal average
            o(1,x) = avg\\\{i(t,x), month(i(t)) = 12, 01, 02\\\}
            o(2,x) = avg\\\{i(t,x), month(i(t)) = 03, 04, 05\\\}
            o(3,x) = avg\\\{i(t,x), month(i(t)) = 06, 07, 08\\\}
            o(4,x) = avg\\\{i(t,x), month(i(t)) = 09, 10, 11\\\}
yseasstd    Multi-year seasonal standard deviation
            o(1,x) = std\\\{i(t,x), month(i(t)) = 12, 01, 02\\\}
            o(2,x) = std\\\{i(t,x), month(i(t)) = 03, 04, 05\\\}
            o(3,x) = std\\\{i(t,x), month(i(t)) = 06, 07, 08\\\}
            o(4,x) = std\\\{i(t,x), month(i(t)) = 09, 10, 11\\\}
yseasstd1   Multi-year seasonal standard deviation (n-1)
            o(1,x) = std1\\\{i(t,x), month(i(t)) = 12, 01, 02\\\}
            o(2,x) = std1\\\{i(t,x), month(i(t)) = 03, 04, 05\\\}
            o(3,x) = std1\\\{i(t,x), month(i(t)) = 06, 07, 08\\\}
            o(4,x) = std1\\\{i(t,x), month(i(t)) = 09, 10, 11\\\}
yseasvar    Multi-year seasonal variance
            o(1,x) = var\\\{i(t,x), month(i(t)) = 12, 01, 02\\\}
            o(2,x) = var\\\{i(t,x), month(i(t)) = 03, 04, 05\\\}
            o(3,x) = var\\\{i(t,x), month(i(t)) = 06, 07, 08\\\}
            o(4,x) = var\\\{i(t,x), month(i(t)) = 09, 10, 11\\\}
yseasvar1   Multi-year seasonal variance (n-1)
            o(1,x) = var1\\\{i(t,x), month(i(t)) = 12, 01, 02\\\}
            o(2,x) = var1\\\{i(t,x), month(i(t)) = 03, 04, 05\\\}
            o(3,x) = var1\\\{i(t,x), month(i(t)) = 06, 07, 08\\\}
            o(4,x) = var1\\\{i(t,x), month(i(t)) = 09, 10, 11\\\}
}\if{html}{\out{</div>}}
}
