/*
 * Decompiled with CFR 0.152.
 */
package org.openscience.cdk.graph;

import java.util.BitSet;
import org.openscience.cdk.graph.InitialCycles;

final class BitMatrix {
    private final BitSet[] rows;
    private final int[] indices;
    private final int max;
    private final int n;
    private int m;

    BitMatrix(int columns, int rows) {
        this.n = columns;
        this.max = rows;
        this.rows = new BitSet[rows];
        this.indices = new int[rows];
    }

    void swap(int i, int j) {
        BitSet row = this.rows[i];
        int k = this.indices[i];
        this.rows[i] = this.rows[j];
        this.indices[i] = this.indices[j];
        this.rows[j] = row;
        this.indices[j] = k;
    }

    private int rowIndex(int j) {
        for (int i = 0; i < this.indices.length; ++i) {
            if (this.indices[i] != j) continue;
            return i;
        }
        return -1;
    }

    public BitSet row(int j) {
        return this.rows[this.rowIndex(j)];
    }

    public boolean eliminated(int j) {
        return this.row(j).isEmpty();
    }

    public void clear() {
        this.m = 0;
    }

    public void add(BitSet row) {
        if (this.m >= this.max) {
            throw new IndexOutOfBoundsException("initalise matrix with more rows");
        }
        this.rows[this.m] = row;
        this.indices[this.m] = this.m;
        ++this.m;
    }

    public int eliminate() {
        return this.eliminate(0, 0);
    }

    private int eliminate(int x, int y) {
        while (x < this.n && y < this.m) {
            int i = this.indexOf(x, y);
            if (i < 0) {
                return this.eliminate(x + 1, y);
            }
            if (i != y) {
                this.swap(i, y);
            }
            for (int j = y + 1; j < this.m; ++j) {
                if (!this.rows[j].get(x)) continue;
                this.rows[j] = BitMatrix.xor(this.rows[j], this.rows[y]);
            }
            ++y;
        }
        return y;
    }

    int indexOf(int x, int y) {
        for (int j = y; j < this.m; ++j) {
            if (!this.rows[j].get(x)) continue;
            return j;
        }
        return -1;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder((4 + this.n) * this.m);
        for (int j = 0; j < this.m; ++j) {
            sb.append(this.indices[j]).append(": ");
            for (int i = 0; i < this.n; ++i) {
                sb.append(this.rows[j].get(i) ? (char)'1' : '-');
            }
            sb.append('\n');
        }
        return sb.toString();
    }

    static BitSet xor(BitSet u, BitSet v) {
        BitSet w = (BitSet)u.clone();
        w.xor(v);
        return w;
    }

    static BitMatrix from(Iterable<InitialCycles.Cycle> cycles) {
        int rows = 0;
        int cols = 0;
        for (InitialCycles.Cycle c : cycles) {
            if (c.edgeVector().length() > cols) {
                cols = c.edgeVector().length();
            }
            ++rows;
        }
        BitMatrix matrix = new BitMatrix(cols, rows);
        for (InitialCycles.Cycle c : cycles) {
            matrix.add(c.edgeVector());
        }
        return matrix;
    }

    static BitMatrix from(Iterable<InitialCycles.Cycle> cycles, InitialCycles.Cycle cycle) {
        int rows = 1;
        int cols = cycle.edgeVector().length();
        for (InitialCycles.Cycle c : cycles) {
            if (c.edgeVector().length() > cols) {
                cols = c.edgeVector().length();
            }
            ++rows;
        }
        BitMatrix matrix = new BitMatrix(cols, rows);
        for (InitialCycles.Cycle c : cycles) {
            matrix.add(c.edgeVector());
        }
        matrix.add(cycle.edgeVector());
        return matrix;
    }
}

