/*
 * Decompiled with CFR 0.152.
 */
package org.openscience.cdk.isomorphism.matchers.smarts;

import java.util.List;
import org.openscience.cdk.interfaces.IAtom;
import org.openscience.cdk.interfaces.IChemObjectBuilder;
import org.openscience.cdk.isomorphism.matchers.smarts.SMARTSAtom;

public class HydrogenAtom
extends SMARTSAtom {
    public HydrogenAtom(IChemObjectBuilder builder) {
        super(builder);
    }

    @Override
    public boolean matches(IAtom atom) {
        if (!atom.getSymbol().equals("H")) {
            return false;
        }
        if (atom.getFormalCharge() == 1) {
            return true;
        }
        List<IAtom> list = this.invariants(atom).target().getConnectedAtomsList(atom);
        for (IAtom connAtom : list) {
            if (!connAtom.getSymbol().equals("H")) continue;
            return true;
        }
        if (this.invariants(atom).degree() > 1) {
            return true;
        }
        return atom.getMassNumber() != null ? this.getMassNumber().intValue() == atom.getMassNumber().intValue() : this.getMassNumber() == 1;
    }
}

