/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.ebi.beam;

import uk.ac.ebi.beam.AbstractFunction;
import uk.ac.ebi.beam.Atom;
import uk.ac.ebi.beam.Bond;
import uk.ac.ebi.beam.Edge;
import uk.ac.ebi.beam.Graph;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
final class ExplicitToImplicit
extends AbstractFunction<Graph, Graph> {
    ExplicitToImplicit() {
    }

    @Override
    public Graph apply(Graph g) {
        int u;
        Graph h = new Graph(g.order());
        for (u = 0; u < g.order(); ++u) {
            h.addAtom(g.atom(u));
            h.addTopology(g.topologyOf(u));
        }
        for (u = 0; u < g.order(); ++u) {
            for (Edge e : g.edges(u)) {
                if (e.other(u) <= u) continue;
                h.addEdge(ExplicitToImplicit.toImplicitEdge(g, e));
            }
        }
        return h;
    }

    static Edge toImplicitEdge(Graph g, Edge e) {
        int u = e.either();
        int v = e.other(u);
        if (e.bond() == Bond.SINGLE || e.bond() == Bond.AROMATIC) {
            return new Edge(u, v, ExplicitToImplicit.type(g.atom(u), g.atom(v), e.bond()));
        }
        return e;
    }

    static Bond type(Atom u, Atom v, Bond b) {
        if (u.aromatic() && v.aromatic()) {
            return b == Bond.AROMATIC ? Bond.IMPLICIT : b;
        }
        return b == Bond.AROMATIC ? Bond.AROMATIC : Bond.IMPLICIT;
    }
}

