/*
 * Decompiled with CFR 0.152.
 */
package org.openscience.cdk.smiles;

import com.google.common.base.Preconditions;
import com.google.common.collect.Maps;
import java.util.HashMap;
import java.util.Map;
import org.openscience.cdk.annotations.TestClass;
import org.openscience.cdk.annotations.TestMethod;
import org.openscience.cdk.interfaces.IAtom;
import org.openscience.cdk.interfaces.IAtomContainer;
import org.openscience.cdk.interfaces.IAtomParity;
import org.openscience.cdk.interfaces.IBond;
import org.openscience.cdk.interfaces.IDoubleBondStereochemistry;
import org.openscience.cdk.interfaces.IStereoElement;
import org.openscience.cdk.interfaces.ITetrahedralChirality;
import uk.ac.ebi.beam.Atom;
import uk.ac.ebi.beam.AtomBuilder;
import uk.ac.ebi.beam.Bond;
import uk.ac.ebi.beam.Configuration;
import uk.ac.ebi.beam.Edge;
import uk.ac.ebi.beam.Graph;
import uk.ac.ebi.beam.GraphBuilder;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@TestClass(value="org.openscience.cdk.smiles.CDKToBeamTest")
final class CDKToBeam {
    private final boolean isomeric;

    CDKToBeam() {
        this(true);
    }

    CDKToBeam(boolean isomeric) {
        this.isomeric = isomeric;
    }

    @TestMethod(value="adenine,benzene,imidazole")
    Graph toBeamGraph(IAtomContainer ac) {
        int order = ac.getAtomCount();
        GraphBuilder gb = GraphBuilder.create(order);
        HashMap<IAtom, Integer> indices = Maps.newHashMapWithExpectedSize(order);
        for (IAtom a : ac.atoms()) {
            indices.put(a, indices.size());
            gb.add(this.toBeamAtom(a));
        }
        for (IBond b : ac.bonds()) {
            gb.add(this.toBeamEdge(b, indices));
        }
        if (this.isomeric) {
            for (IStereoElement se : ac.stereoElements()) {
                if (se instanceof ITetrahedralChirality) {
                    this.addTetrahedralConfiguration((ITetrahedralChirality)se, gb, indices);
                    continue;
                }
                if (se instanceof IDoubleBondStereochemistry) {
                    this.addGeometricConfiguration((IDoubleBondStereochemistry)se, gb, indices);
                    continue;
                }
                if (!(se instanceof IAtomParity)) continue;
                this.addAtomParityConfiguration((IAtomParity)se, gb, indices);
            }
        }
        return gb.build();
    }

    @TestMethod(value="aliphaticAtom,aromaticAtom")
    Atom toBeamAtom(IAtom a) {
        Integer massNumber;
        AtomBuilder ab;
        boolean aromatic = a.getFlag(32);
        Integer hCount = Preconditions.checkNotNull(a.getImplicitHydrogenCount(), "An atom had an undefined number of implicit hydrogens");
        Integer charge = a.getFormalCharge();
        String symbol = Preconditions.checkNotNull(a.getSymbol(), "An atom had an undefined symbol");
        AtomBuilder atomBuilder = ab = aromatic ? AtomBuilder.aromatic(symbol).hydrogens(hCount) : AtomBuilder.aliphatic(symbol).hydrogens(hCount);
        if (charge != null) {
            ab.charge(charge);
        }
        if (this.isomeric && (massNumber = a.getMassNumber()) != null) {
            ab.isotope(massNumber);
        }
        return ab.build();
    }

    @TestMethod(value="singleBond,doubleBond,tripleBond")
    Edge toBeamEdge(IBond b, Map<IAtom, Integer> indices) {
        Preconditions.checkArgument(b.getAtomCount() == 2, "Invalid number of atoms on bond");
        int u = indices.get(b.getAtom(0));
        int v = indices.get(b.getAtom(1));
        return this.toBeamEdgeLabel(b).edge(u, v);
    }

    private Bond toBeamEdgeLabel(IBond b) {
        if (b.getFlag(32)) {
            return Bond.AROMATIC;
        }
        IBond.Order order = Preconditions.checkNotNull(b.getOrder(), "A bond had undefined order");
        switch (order) {
            case SINGLE: {
                return Bond.SINGLE;
            }
            case DOUBLE: {
                return Bond.DOUBLE;
            }
            case TRIPLE: {
                return Bond.TRIPLE;
            }
            case QUADRUPLE: {
                return Bond.QUADRUPLE;
            }
        }
        throw new IllegalArgumentException("Unsupported bond order: " + (Object)((Object)order));
    }

    private void addGeometricConfiguration(IDoubleBondStereochemistry dbs, GraphBuilder gb, Map<IAtom, Integer> indices) {
        IBond db = dbs.getStereoBond();
        IBond[] bs = dbs.getBonds();
        int u = indices.get(db.getAtom(0));
        int v = indices.get(db.getAtom(1));
        int x = indices.get(bs[0].getConnectedAtom(db.getAtom(0)));
        int y = indices.get(bs[1].getConnectedAtom(db.getAtom(1)));
        if (dbs.getStereo() == IDoubleBondStereochemistry.Conformation.TOGETHER) {
            gb.geometric(u, v).together(x, y);
        } else {
            gb.geometric(u, v).opposite(x, y);
        }
    }

    private void addTetrahedralConfiguration(ITetrahedralChirality tc, GraphBuilder gb, Map<IAtom, Integer> indices) {
        IAtom[] ligands = tc.getLigands();
        int u = indices.get(tc.getChiralAtom());
        int[] vs = new int[]{indices.get(ligands[0]), indices.get(ligands[1]), indices.get(ligands[2]), indices.get(ligands[3])};
        gb.tetrahedral(u).lookingFrom(vs[0]).neighbors(vs[1], vs[2], vs[3]).winding(tc.getStereo() == ITetrahedralChirality.Stereo.CLOCKWISE ? Configuration.CLOCKWISE : Configuration.ANTI_CLOCKWISE).build();
    }

    private void addAtomParityConfiguration(IAtomParity ap, GraphBuilder gb, Map<IAtom, Integer> indices) {
        IAtom[] ligands = ap.getSurroundingAtoms();
        int u = indices.get(ap.getAtom());
        int[] vs = new int[]{indices.get(ligands[0]), indices.get(ligands[1]), indices.get(ligands[2]), indices.get(ligands[3])};
        gb.tetrahedral(u).lookingFrom(vs[0]).neighbors(vs[1], vs[2], vs[3]).parity(ap.getParity()).build();
    }
}

