/*
 * Decompiled with CFR 0.152.
 */
package org.openscience.cdk.hash.stereo;

import javax.vecmath.Point3d;
import org.openscience.cdk.annotations.TestClass;
import org.openscience.cdk.annotations.TestMethod;
import org.openscience.cdk.hash.stereo.GeometricParity;

@TestClass(value="org.openscience.cdk.hash.stereo.Tetrahedral3DParityTest")
final class Tetrahedral3DParity
extends GeometricParity {
    private final Point3d[] coordinates;

    @TestMethod(value="testConstruction_Empty")
    public Tetrahedral3DParity(Point3d[] coordinates) {
        if (coordinates.length != 4) {
            throw new IllegalArgumentException("4 coordinates expected");
        }
        this.coordinates = coordinates;
    }

    @TestMethod(value="testParity_Three_Clockwise,testParity_Three_Anticlockwise,testParity_Four_Clockwise,testParity_Four_Anticlockwise")
    public int parity() {
        double x1 = this.coordinates[0].x;
        double x2 = this.coordinates[1].x;
        double x3 = this.coordinates[2].x;
        double x4 = this.coordinates[3].x;
        double y1 = this.coordinates[0].y;
        double y2 = this.coordinates[1].y;
        double y3 = this.coordinates[2].y;
        double y4 = this.coordinates[3].y;
        double z1 = this.coordinates[0].z;
        double z2 = this.coordinates[1].z;
        double z3 = this.coordinates[2].z;
        double z4 = this.coordinates[3].z;
        double det = z1 * Tetrahedral3DParity.det(x2, y2, x3, y3, x4, y4) - z2 * Tetrahedral3DParity.det(x1, y1, x3, y3, x4, y4) + z3 * Tetrahedral3DParity.det(x1, y1, x2, y2, x4, y4) - z4 * Tetrahedral3DParity.det(x1, y1, x2, y2, x3, y3);
        return (int)Math.signum(det);
    }

    private static double det(double xa, double ya, double xb, double yb, double xc, double yc) {
        return (xa - xc) * (yb - yc) - (ya - yc) * (xb - xc);
    }
}

