/*
 * Decompiled with CFR 0.152.
 */
package org.openscience.cdk.hash;

import org.openscience.cdk.annotations.TestClass;
import org.openscience.cdk.annotations.TestMethod;
import org.openscience.cdk.hash.AtomEncoder;
import org.openscience.cdk.interfaces.IAtom;
import org.openscience.cdk.interfaces.IAtomContainer;
import org.openscience.cdk.interfaces.IAtomType;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@TestClass(value="org.openscience.cdk.hash.BasicAtomEncoderTest")
public enum BasicAtomEncoder implements AtomEncoder
{
    ATOMIC_NUMBER{

        @TestMethod(value="testAtomicNumber,testAtomicNumber_Null")
        public int encode(IAtom atom, IAtomContainer container) {
            Integer atomicNumber = atom.getAtomicNumber();
            return atomicNumber != null ? atomicNumber : 32451169;
        }
    }
    ,
    MASS_NUMBER{

        @TestMethod(value="testMassNumber,testMassNumber_Null")
        public int encode(IAtom atom, IAtomContainer container) {
            Integer massNumber = atom.getMassNumber();
            return massNumber != null ? massNumber : 32451179;
        }
    }
    ,
    FORMAL_CHARGE{

        @TestMethod(value="testFormalCharge,testFormalCharge_Null")
        public int encode(IAtom atom, IAtomContainer container) {
            Integer formalCharge = atom.getFormalCharge();
            return formalCharge != null ? formalCharge : 32451193;
        }
    }
    ,
    N_CONNECTED_ATOMS{

        @TestMethod(value="testNConnectedAtoms")
        public int encode(IAtom atom, IAtomContainer container) {
            return container.getConnectedAtomsCount(atom);
        }
    }
    ,
    BOND_ORDER_SUM{

        public int encode(IAtom atom, IAtomContainer container) {
            return Double.valueOf(container.getBondOrderSum(atom)).hashCode();
        }
    }
    ,
    ORBITAL_HYBRIDIZATION{

        @TestMethod(value="testOrbitalHybridization,testOrbitalHybridization_Null")
        public int encode(IAtom atom, IAtomContainer container) {
            IAtomType.Hybridization hybridization = atom.getHybridization();
            return hybridization != null ? hybridization.ordinal() : 32451301;
        }
    }
    ,
    FREE_RADICALS{

        @TestMethod(value="testFreeRadicals")
        public int encode(IAtom atom, IAtomContainer container) {
            return container.getConnectedSingleElectronsCount(atom);
        }
    };

}

