/*
 * Decompiled with CFR 0.152.
 */
package org.openscience.cdk.fingerprint;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import java.util.TreeSet;
import org.openscience.cdk.annotations.TestClass;
import org.openscience.cdk.annotations.TestMethod;
import org.openscience.cdk.graph.AllPairsShortestPaths;
import org.openscience.cdk.interfaces.IAtom;
import org.openscience.cdk.interfaces.IAtomContainer;
import org.openscience.cdk.interfaces.IBond;
import org.openscience.cdk.interfaces.IPseudoAtom;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@TestClass(value="org.openscience.cdk.fingerprint.ShortestPathWalkerTest")
public final class ShortestPathWalker {
    private final IAtomContainer container;
    private final Set<String> paths;
    private final List<String> pseudoAtoms;
    private static final int MAX_SHORTEST_PATHS = 5;

    public ShortestPathWalker(IAtomContainer container) {
        this.container = container;
        this.pseudoAtoms = new ArrayList<String>(5);
        this.paths = Collections.unmodifiableSet(this.traverse());
    }

    @TestMethod(value="testPaths")
    public Set<String> paths() {
        return Collections.unmodifiableSet(this.paths);
    }

    private Set<String> traverse() {
        TreeSet<String> paths = new TreeSet<String>();
        AllPairsShortestPaths apsp = new AllPairsShortestPaths(this.container);
        int n = this.container.getAtomCount();
        for (int i = 0; i < n; ++i) {
            paths.add(this.toAtomPattern(this.container.getAtom(i)));
            for (int j = i + 1; j < n; ++j) {
                int nPaths = apsp.from(i).nPathsTo(j);
                if (nPaths <= 0 || nPaths >= 5) continue;
                for (int[] path : apsp.from(i).pathsTo(j)) {
                    paths.add(this.encode(path));
                    paths.add(this.encode(this.reverse(path)));
                }
            }
        }
        return paths;
    }

    private int[] reverse(int[] src) {
        int[] dest = Arrays.copyOf(src, src.length);
        int left = 0;
        for (int right = src.length - 1; left < right; ++left, --right) {
            dest[left] = src[right];
            dest[right] = src[left];
        }
        return dest;
    }

    private String encode(int[] path) {
        StringBuilder sb = new StringBuilder(path.length * 3);
        int n = path.length - 1;
        for (int i = 0; i <= n; ++i) {
            IAtom atom = this.container.getAtom(path[i]);
            sb.append(this.toAtomPattern(atom));
            if (atom instanceof IPseudoAtom) {
                this.pseudoAtoms.add(atom.getSymbol());
            }
            if (i >= n) continue;
            IBond bond = this.container.getBond(this.container.getAtom(path[i]), this.container.getAtom(path[i + 1]));
            sb.append(this.getBondSymbol(bond));
        }
        return sb.toString();
    }

    private String toAtomPattern(IAtom atom) {
        return atom.getSymbol();
    }

    private char getBondSymbol(IBond bond) {
        if (this.isSP2Bond(bond)) {
            return '@';
        }
        switch (bond.getOrder()) {
            case SINGLE: {
                return '1';
            }
            case DOUBLE: {
                return '2';
            }
            case TRIPLE: {
                return '3';
            }
            case QUADRUPLE: {
                return '4';
            }
        }
        return '5';
    }

    private boolean isSP2Bond(IBond bond) {
        return bond.getFlag(32);
    }

    @TestMethod(value="testToString")
    public String toString() {
        int n = this.paths.size();
        String[] paths = this.paths.toArray(new String[n]);
        StringBuilder sb = new StringBuilder(n * 5);
        int last = n - 1;
        for (int i = 0; i < n; ++i) {
            sb.append(paths[i]);
            if (i == last) continue;
            sb.append("->");
        }
        return sb.toString();
    }
}

