/*
 * Decompiled with CFR 0.152.
 */
package org.openscience.cdk.atomtype;

import org.openscience.cdk.annotations.TestMethod;
import org.openscience.cdk.atomtype.IAtomTypeMatcher;
import org.openscience.cdk.config.AtomTypeFactory;
import org.openscience.cdk.exception.CDKException;
import org.openscience.cdk.interfaces.IAtom;
import org.openscience.cdk.interfaces.IAtomContainer;
import org.openscience.cdk.interfaces.IAtomType;
import org.openscience.cdk.interfaces.IBond;
import org.openscience.cdk.tools.ILoggingTool;
import org.openscience.cdk.tools.LoggingToolFactory;
import org.openscience.cdk.tools.manipulator.BondManipulator;

public class StructGenMatcher
implements IAtomTypeMatcher {
    private static AtomTypeFactory factory = null;
    private static ILoggingTool logger = LoggingToolFactory.createLoggingTool(StructGenMatcher.class);

    @TestMethod(value="testFindMatchingAtomType_IAtomContainer")
    public IAtomType[] findMatchingAtomTypes(IAtomContainer atomContainer) throws CDKException {
        IAtomType[] types = new IAtomType[atomContainer.getAtomCount()];
        int typeCounter = 0;
        for (IAtom atom : atomContainer.atoms()) {
            types[typeCounter] = this.findMatchingAtomType(atomContainer, atom);
            ++typeCounter;
        }
        return types;
    }

    public IAtomType findMatchingAtomType(IAtomContainer atomContainer, IAtom atom) throws CDKException {
        IAtomType[] types;
        if (factory == null) {
            try {
                factory = AtomTypeFactory.getInstance("org/openscience/cdk/config/data/structgen_atomtypes.xml", atom.getBuilder());
            }
            catch (Exception ex1) {
                logger.error(ex1.getMessage());
                logger.debug(ex1);
                throw new CDKException("Could not instantiate the AtomType list!", ex1);
            }
        }
        double bondOrderSum = atomContainer.getBondOrderSum(atom);
        IBond.Order maxBondOrder = atomContainer.getMaximumBondOrder(atom);
        int charge = atom.getFormalCharge();
        int hcount = atom.getImplicitHydrogenCount() == null ? 0 : atom.getImplicitHydrogenCount();
        for (IAtomType type : types = factory.getAtomTypes(atom.getSymbol())) {
            logger.debug("   ... matching atom ", atom, " vs ", type);
            if (bondOrderSum - (double)charge + (double)hcount != type.getBondOrderSum() || BondManipulator.isHigherOrder(maxBondOrder, type.getMaxBondOrder())) continue;
            return type;
        }
        logger.debug("    No Match");
        return null;
    }
}

