/*
 * Decompiled with CFR 0.152.
 */
package org.openscience.cdk.io.iterator;

import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.util.HashMap;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.openscience.cdk.exception.CDKException;
import org.openscience.cdk.interfaces.IAtomContainer;
import org.openscience.cdk.interfaces.IChemObject;
import org.openscience.cdk.interfaces.IChemObjectBuilder;
import org.openscience.cdk.io.ISimpleChemObjectReader;
import org.openscience.cdk.io.ReaderFactory;
import org.openscience.cdk.io.formats.IChemFormat;
import org.openscience.cdk.io.formats.IResourceFormat;
import org.openscience.cdk.io.formats.MDLFormat;
import org.openscience.cdk.io.formats.MDLV2000Format;
import org.openscience.cdk.io.formats.MDLV3000Format;
import org.openscience.cdk.io.iterator.DefaultIteratingChemObjectReader;
import org.openscience.cdk.io.setting.BooleanIOSetting;
import org.openscience.cdk.io.setting.IOSetting;
import org.openscience.cdk.tools.ILoggingTool;
import org.openscience.cdk.tools.LoggingToolFactory;

public class IteratingSDFReader
extends DefaultIteratingChemObjectReader<IAtomContainer> {
    private BufferedReader input;
    private static ILoggingTool logger = LoggingToolFactory.createLoggingTool(IteratingSDFReader.class);
    private String currentLine;
    private IChemFormat currentFormat;
    private final ReaderFactory factory = new ReaderFactory();
    private boolean nextAvailableIsKnown;
    private boolean hasNext;
    private IChemObjectBuilder builder;
    private IAtomContainer nextMolecule;
    private BooleanIOSetting forceReadAs3DCoords;
    private boolean skip = false;
    private StringBuffer buffer = new StringBuffer(10000);
    private static final String LINE_SEPARATOR = System.getProperty("line.separator");
    private static Pattern MDL_VERSION = Pattern.compile("[vV](2000|3000)");
    private static Pattern M_END = Pattern.compile("M\\s\\sEND");
    private static Pattern SDF_RECORD_SEPARATOR = Pattern.compile("\\$\\$\\$\\$");
    private static Pattern SDF_FIELD_START = Pattern.compile("\\A>\\s");
    private final Map<IChemFormat, ISimpleChemObjectReader> readerMap = new HashMap<IChemFormat, ISimpleChemObjectReader>(5);

    public IteratingSDFReader(Reader in, IChemObjectBuilder builder) {
        this(in, builder, false);
    }

    public IteratingSDFReader(InputStream in, IChemObjectBuilder builder) {
        this(new InputStreamReader(in), builder);
    }

    public IteratingSDFReader(InputStream in, IChemObjectBuilder builder, boolean skip) {
        this(new InputStreamReader(in), builder, skip);
    }

    public IteratingSDFReader(Reader in, IChemObjectBuilder builder, boolean skip) {
        this.builder = builder;
        this.setReader(in);
        this.initIOSettings();
        this.setSkip(skip);
    }

    @Override
    public IResourceFormat getFormat() {
        return this.currentFormat;
    }

    private ISimpleChemObjectReader getReader(IChemFormat format) {
        if (!this.readerMap.containsKey(format)) {
            ISimpleChemObjectReader reader = this.factory.createReader(format);
            reader.setErrorHandler(this.errorHandler);
            reader.setReaderMode(this.mode);
            if (this.currentFormat instanceof MDLV2000Format) {
                reader.addSettings(this.getSettings());
            }
            this.readerMap.put(format, reader);
        }
        return this.readerMap.get(format);
    }

    @Override
    public boolean hasNext() {
        if (this.nextAvailableIsKnown) {
            return this.hasNext;
        }
        this.hasNext = false;
        this.nextMolecule = null;
        this.buffer.delete(0, this.buffer.length());
        try {
            this.currentFormat = (IChemFormat)MDLFormat.getInstance();
            while ((this.currentLine = this.input.readLine()) != null) {
                this.buffer.append(this.currentLine).append(LINE_SEPARATOR);
                Matcher versionMatcher = MDL_VERSION.matcher(this.currentLine);
                if (versionMatcher.find()) {
                    this.currentFormat = "2000".equals(versionMatcher.group(1)) ? (IChemFormat)MDLV2000Format.getInstance() : (IChemFormat)MDLV3000Format.getInstance();
                }
                this.currentLine = this.currentLine.trim();
                if (M_END.matcher(this.currentLine).matches()) {
                    logger.debug("MDL file part read: ", this.buffer);
                    IAtomContainer molecule = null;
                    try {
                        ISimpleChemObjectReader reader = this.getReader(this.currentFormat);
                        ByteArrayInputStream byteStream = new ByteArrayInputStream(this.buffer.toString().getBytes("UTF-8"));
                        reader.setReader(byteStream);
                        molecule = (IAtomContainer)reader.read((IChemObject)this.builder.newInstance(IAtomContainer.class, new Object[0]));
                        ((InputStream)byteStream).close();
                    }
                    catch (IOException | IllegalArgumentException | CDKException exception) {
                        logger.error("Error while reading next molecule: " + exception.getMessage());
                        logger.debug(exception);
                    }
                    if (molecule != null) {
                        this.readDataBlockInto(molecule);
                        this.hasNext = true;
                        this.nextAvailableIsKnown = true;
                        this.nextMolecule = molecule;
                        return true;
                    }
                    if (this.skip) {
                        String line;
                        while ((line = this.input.readLine()) != null && !SDF_RECORD_SEPARATOR.matcher(line).matches()) {
                            this.buffer.delete(0, this.buffer.length());
                        }
                    } else {
                        return false;
                    }
                    this.buffer.delete(0, this.buffer.length());
                }
                if (!SDF_RECORD_SEPARATOR.matcher(this.currentLine).matches()) continue;
                this.buffer.delete(0, this.buffer.length());
            }
        }
        catch (IOException exception) {
            logger.error("Error while reading next molecule: " + exception.getMessage());
            logger.debug(exception);
        }
        return false;
    }

    private void readDataBlockInto(IAtomContainer m) throws IOException {
        String fieldName = null;
        while ((this.currentLine = this.input.readLine()) != null && !SDF_RECORD_SEPARATOR.matcher(this.currentLine).matches()) {
            logger.debug("looking for data header: ", this.currentLine);
            String str = this.currentLine;
            if (!SDF_FIELD_START.matcher(str).find()) continue;
            fieldName = this.extractFieldName(fieldName, str);
            str = this.skipOtherFieldHeaderLines(str);
            String data = this.extractFieldData(str);
            if (fieldName == null) continue;
            logger.info("fieldName, data: ", fieldName, ", ", data);
            m.setProperty(fieldName, data);
        }
    }

    public void setSkip(boolean skip) {
        this.skip = skip;
    }

    private String extractFieldData(String str) throws IOException {
        StringBuilder data = new StringBuilder();
        while (str.trim().length() > 0) {
            logger.debug("data line: ", this.currentLine);
            if (data.length() > 0) {
                str = System.getProperty("line.separator") + str;
            }
            data.append(str);
            this.currentLine = this.input.readLine();
            str = this.currentLine.trim();
        }
        return data.toString();
    }

    private String skipOtherFieldHeaderLines(String str) throws IOException {
        while (str.startsWith("> ")) {
            logger.debug("data header line: ", this.currentLine);
            str = this.currentLine = this.input.readLine();
        }
        return str;
    }

    private String extractFieldName(String fieldName, String str) {
        int index2;
        int index = str.indexOf(60);
        if (index != -1 && (index2 = str.substring(index).indexOf(62)) != -1) {
            fieldName = str.substring(index + 1, index + index2);
        }
        return fieldName;
    }

    @Override
    public IAtomContainer next() {
        if (!this.nextAvailableIsKnown) {
            this.hasNext();
        }
        this.nextAvailableIsKnown = false;
        if (!this.hasNext) {
            throw new NoSuchElementException();
        }
        return this.nextMolecule;
    }

    @Override
    public void close() throws IOException {
        this.input.close();
    }

    @Override
    public void remove() {
        throw new UnsupportedOperationException();
    }

    @Override
    public void setReader(Reader reader) {
        this.input = reader instanceof BufferedReader ? (BufferedReader)reader : new BufferedReader(reader);
        this.nextMolecule = null;
        this.nextAvailableIsKnown = false;
        this.hasNext = false;
    }

    @Override
    public void setReader(InputStream reader) {
        this.setReader(new InputStreamReader(reader));
    }

    private void initIOSettings() {
        this.forceReadAs3DCoords = new BooleanIOSetting("ForceReadAs3DCoordinates", IOSetting.Importance.LOW, "Should coordinates always be read as 3D?", "false");
        this.addSetting(this.forceReadAs3DCoords);
    }

    public void customizeJob() {
        this.fireIOSettingQuestion(this.forceReadAs3DCoords);
    }
}

