/*
 * Decompiled with CFR 0.152.
 */
package org.openscience.cdk.fingerprint;

import java.util.BitSet;
import java.util.Map;
import org.openscience.cdk.config.fragments.EStateFragments;
import org.openscience.cdk.exception.CDKException;
import org.openscience.cdk.fingerprint.BitSetFingerprint;
import org.openscience.cdk.fingerprint.IBitFingerprint;
import org.openscience.cdk.fingerprint.ICountFingerprint;
import org.openscience.cdk.fingerprint.IFingerprinter;
import org.openscience.cdk.interfaces.IAtomContainer;
import org.openscience.cdk.smiles.smarts.SMARTSQueryTool;

public class EStateFingerprinter
implements IFingerprinter {
    private static final String[] PATTERNS = EStateFragments.getSmarts();

    @Override
    public IBitFingerprint getBitFingerprint(IAtomContainer atomContainer) throws CDKException {
        int bitsetLength = PATTERNS.length;
        BitSet fingerPrint = new BitSet(bitsetLength);
        SMARTSQueryTool sqt = new SMARTSQueryTool("C", atomContainer.getBuilder());
        for (int i = 0; i < PATTERNS.length; ++i) {
            sqt.setSmarts(PATTERNS[i]);
            boolean status = sqt.matches(atomContainer);
            if (!status) continue;
            fingerPrint.set(i, true);
        }
        return new BitSetFingerprint(fingerPrint);
    }

    @Override
    public Map<String, Integer> getRawFingerprint(IAtomContainer iAtomContainer) throws CDKException {
        throw new UnsupportedOperationException();
    }

    @Override
    public int getSize() {
        return PATTERNS.length;
    }

    @Override
    public ICountFingerprint getCountFingerprint(IAtomContainer container) throws CDKException {
        throw new UnsupportedOperationException();
    }
}

