/*
 * Decompiled with CFR 0.152.
 */
package org.openscience.cdk.silent;

import java.io.Serializable;
import java.util.Collection;
import java.util.Hashtable;
import java.util.Map;
import org.openscience.cdk.interfaces.IAtom;
import org.openscience.cdk.interfaces.IBond;
import org.openscience.cdk.interfaces.ILonePair;
import org.openscience.cdk.interfaces.IMonomer;
import org.openscience.cdk.interfaces.IPolymer;
import org.openscience.cdk.interfaces.ISingleElectron;
import org.openscience.cdk.silent.AtomContainer;
import org.openscience.cdk.silent.Monomer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Polymer
extends AtomContainer
implements Serializable,
IPolymer {
    private static final long serialVersionUID = -2596790658835319339L;
    private Map<String, IMonomer> monomers = new Hashtable<String, IMonomer>();

    @Override
    public void addAtom(IAtom oAtom, IMonomer oMonomer) {
        if (!this.contains(oAtom)) {
            super.addAtom(oAtom);
            if (oMonomer != null) {
                oMonomer.addAtom(oAtom);
                if (!this.monomers.containsKey(oMonomer.getMonomerName())) {
                    this.monomers.put(oMonomer.getMonomerName(), oMonomer);
                }
            }
        }
    }

    @Override
    public int getMonomerCount() {
        return this.monomers.size();
    }

    @Override
    public IMonomer getMonomer(String cName) {
        return this.monomers.get(cName);
    }

    @Override
    public Collection<String> getMonomerNames() {
        return this.monomers.keySet();
    }

    @Override
    public void removeMonomer(String name) {
        if (this.monomers.containsKey(name)) {
            Monomer monomer = (Monomer)this.monomers.get(name);
            this.remove(monomer);
            this.monomers.remove(name);
        }
    }

    @Override
    public String toString() {
        StringBuffer stringContent = new StringBuffer();
        stringContent.append("Polymer(");
        stringContent.append(this.hashCode()).append(", ");
        stringContent.append(super.toString());
        stringContent.append(')');
        return stringContent.toString();
    }

    @Override
    public Object clone() throws CloneNotSupportedException {
        Polymer clone = (Polymer)super.clone();
        clone.removeAllElements();
        clone.monomers = new Hashtable<String, IMonomer>();
        for (String monomerName : this.getMonomerNames()) {
            Monomer monomerClone = (Monomer)this.getMonomer(monomerName).clone();
            for (IAtom atomInMonomer : monomerClone.atoms()) {
                clone.addAtom(atomInMonomer, monomerClone);
            }
        }
        for (IAtom atom : this.atoms()) {
            if (this.atomIsInMonomer(atom)) continue;
            clone.addAtom((IAtom)atom.clone());
        }
        for (IBond bond : this.bonds()) {
            IBond newBond = (IBond)bond.clone();
            IAtom[] newAtoms = new IAtom[bond.getAtomCount()];
            for (int j = 0; j < bond.getAtomCount(); ++j) {
                newAtoms[j] = clone.getAtom(this.getAtomNumber(bond.getAtom(j)));
            }
            newBond.setAtoms(newAtoms);
            clone.addBond(newBond);
        }
        for (int i = 0; i < this.getLonePairCount(); ++i) {
            ILonePair lp = this.getLonePair(i);
            ILonePair newLp = (ILonePair)lp.clone();
            if (lp.getAtom() != null) {
                newLp.setAtom(clone.getAtom(this.getAtomNumber(lp.getAtom())));
            }
            clone.addLonePair(newLp);
        }
        for (int i = 0; i < this.getSingleElectronCount(); ++i) {
            ISingleElectron singleElectron = this.getSingleElectron(i);
            ISingleElectron newSingleElectron = (ISingleElectron)singleElectron.clone();
            if (singleElectron.getAtom() != null) {
                newSingleElectron.setAtom(clone.getAtom(this.getAtomNumber(singleElectron.getAtom())));
            }
            clone.addSingleElectron(newSingleElectron);
        }
        return clone;
    }

    private boolean atomIsInMonomer(IAtom atom) {
        for (String monomerName : this.getMonomerNames()) {
            IMonomer monomer = this.getMonomer(monomerName);
            if (!monomer.contains(atom)) continue;
            return true;
        }
        return false;
    }
}

