/*
 * Decompiled with CFR 0.152.
 */
package org.openscience.cdk.io;

import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.StringWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.List;
import nu.xom.Attribute;
import nu.xom.Document;
import nu.xom.Element;
import nu.xom.Serializer;
import org.openscience.cdk.annotations.TestClass;
import org.openscience.cdk.annotations.TestMethod;
import org.openscience.cdk.exception.CDKException;
import org.openscience.cdk.interfaces.IAtom;
import org.openscience.cdk.interfaces.IAtomContainer;
import org.openscience.cdk.interfaces.IAtomContainerSet;
import org.openscience.cdk.interfaces.IBond;
import org.openscience.cdk.interfaces.IChemFile;
import org.openscience.cdk.interfaces.IChemModel;
import org.openscience.cdk.interfaces.IChemObject;
import org.openscience.cdk.interfaces.IChemSequence;
import org.openscience.cdk.interfaces.ICrystal;
import org.openscience.cdk.interfaces.IPDBPolymer;
import org.openscience.cdk.interfaces.IReaction;
import org.openscience.cdk.interfaces.IReactionScheme;
import org.openscience.cdk.interfaces.IReactionSet;
import org.openscience.cdk.io.DefaultChemObjectWriter;
import org.openscience.cdk.io.cml.CustomSerializer;
import org.openscience.cdk.io.formats.CMLFormat;
import org.openscience.cdk.io.formats.IResourceFormat;
import org.openscience.cdk.io.setting.BooleanIOSetting;
import org.openscience.cdk.io.setting.IOSetting;
import org.openscience.cdk.io.setting.StringIOSetting;
import org.openscience.cdk.libio.cml.Convertor;
import org.openscience.cdk.libio.cml.ICMLCustomizer;
import org.openscience.cdk.tools.ILoggingTool;
import org.openscience.cdk.tools.LoggingToolFactory;
import org.xmlcml.cml.base.CMLElement;

@TestClass(value="org.openscience.cdk.io.CML2WriterTest")
public class CMLWriter
extends DefaultChemObjectWriter {
    private OutputStream output;
    private Writer writer;
    private BooleanIOSetting cmlIds;
    private BooleanIOSetting namespacedOutput;
    private StringIOSetting namespacePrefix;
    private BooleanIOSetting schemaInstanceOutput;
    private StringIOSetting instanceLocation;
    private BooleanIOSetting indent;
    private BooleanIOSetting xmlDeclaration;
    private static ILoggingTool logger = LoggingToolFactory.createLoggingTool(CMLWriter.class);
    private List<ICMLCustomizer> customizers = null;

    public CMLWriter(Writer out) {
        this.writer = out;
        this.output = new OutputStream(){

            public void write(int anInt) throws IOException {
                CMLWriter.this.writer.write(anInt);
            }
        };
        this.initIOSettings();
    }

    public CMLWriter(OutputStream output) {
        this.output = output;
        this.writer = null;
        this.initIOSettings();
    }

    public CMLWriter() {
        this(new StringWriter());
    }

    public void registerCustomizer(ICMLCustomizer customizer) {
        if (this.customizers == null) {
            this.customizers = new ArrayList<ICMLCustomizer>();
        }
        this.customizers.add(customizer);
        logger.info("Loaded Customizer: ", customizer.getClass().getName());
    }

    @TestMethod(value="testGetFormat")
    public IResourceFormat getFormat() {
        return CMLFormat.getInstance();
    }

    public void setWriter(Writer writer) throws CDKException {
        this.writer = writer;
    }

    public void setWriter(OutputStream output) throws CDKException {
        this.output = output;
        this.setWriter(new OutputStreamWriter(output));
    }

    @TestMethod(value="testClose")
    public void close() throws IOException {
        this.output.close();
    }

    @TestMethod(value="testAccepts")
    public boolean accepts(Class classObject) {
        Class<?>[] interfaces = classObject.getInterfaces();
        for (int i = 0; i < interfaces.length; ++i) {
            if (IAtom.class.equals(interfaces[i])) {
                return true;
            }
            if (IBond.class.equals(interfaces[i])) {
                return true;
            }
            if (ICrystal.class.equals(interfaces[i])) {
                return true;
            }
            if (IChemModel.class.equals(interfaces[i])) {
                return true;
            }
            if (IChemFile.class.equals(interfaces[i])) {
                return true;
            }
            if (IChemSequence.class.equals(interfaces[i])) {
                return true;
            }
            if (IAtomContainerSet.class.equals(interfaces[i])) {
                return true;
            }
            if (IReactionSet.class.equals(interfaces[i])) {
                return true;
            }
            if (!IReaction.class.equals(interfaces[i])) continue;
            return true;
        }
        return false;
    }

    public void write(IChemObject object) throws CDKException {
        if (!(object instanceof IAtomContainer || object instanceof IAtomContainerSet || object instanceof IReaction || object instanceof IReactionSet || object instanceof IChemSequence || object instanceof IChemModel || object instanceof IChemFile || object instanceof ICrystal || object instanceof IAtom || object instanceof IBond)) {
            throw new CDKException("Cannot write this unsupported IChemObject: " + object.getClass().getName());
        }
        logger.debug("Writing object in CML of type: ", object.getClass().getName());
        this.customizeJob();
        Convertor convertor = new Convertor(this.cmlIds.isSet(), this.namespacePrefix.getSetting().length() > 0 ? this.namespacePrefix.getSetting() : null);
        if (this.customizers != null) {
            for (ICMLCustomizer customizer : this.customizers) {
                convertor.registerCustomizer(customizer);
            }
        }
        CMLElement root = null;
        if (object instanceof IPDBPolymer) {
            root = convertor.cdkPDBPolymerToCMLMolecule((IPDBPolymer)object);
        } else if (object instanceof ICrystal) {
            root = convertor.cdkCrystalToCMLMolecule((ICrystal)object);
        } else if (object instanceof IAtom) {
            root = convertor.cdkAtomToCMLAtom(null, (IAtom)object);
        } else if (object instanceof IBond) {
            root = convertor.cdkBondToCMLBond((IBond)object);
        } else if (object instanceof IReaction) {
            root = convertor.cdkReactionToCMLReaction((IReaction)object);
        } else if (object instanceof IReactionScheme) {
            root = convertor.cdkReactionSchemeToCMLReactionSchemeAndMoleculeList((IReactionScheme)object);
        } else if (object instanceof IReactionSet) {
            root = convertor.cdkReactionSetToCMLReactionList((IReactionSet)object);
        } else if (object instanceof IAtomContainerSet) {
            root = convertor.cdkAtomContainerSetToCMLList((IAtomContainerSet)object);
        } else if (object instanceof IChemSequence) {
            root = convertor.cdkChemSequenceToCMLList((IChemSequence)object);
        } else if (object instanceof IChemModel) {
            root = convertor.cdkChemModelToCMLList((IChemModel)object);
        } else if (object instanceof IAtomContainer) {
            root = convertor.cdkAtomContainerToCMLMolecule((IAtomContainer)object);
        } else if (object instanceof IChemFile) {
            root = convertor.cdkChemFileToCMLList((IChemFile)object);
        }
        Document doc = new Document(root);
        try {
            Serializer serializer = null;
            serializer = this.xmlDeclaration.isSet() ? new Serializer(this.output, "ISO-8859-1") : new CustomSerializer(this.output, "ISO-8859-1");
            if (this.indent.isSet()) {
                logger.info("Indenting XML output");
                serializer.setIndent(2);
            }
            if (this.schemaInstanceOutput.isSet()) {
                ((Element)root).addNamespaceDeclaration("xsi", "http://www.w3.org/2001/XMLSchema-instance");
                root.addAttribute(new Attribute("xsi:schemaLocation=", "http://www.w3.org/2001/XMLSchema-instance", "http://www.xml-cml.org/schema/cml2/core " + this.instanceLocation.getSetting()));
            }
            serializer.write(doc);
        }
        catch (Exception exception) {
            throw new CDKException("Could not write XML output: " + exception.getMessage(), exception);
        }
    }

    private void initIOSettings() {
        this.cmlIds = (BooleanIOSetting)this.addSetting(new BooleanIOSetting("CMLIDs", IOSetting.Importance.LOW, "Should the output use CML identifiers?", "true"));
        this.namespacedOutput = (BooleanIOSetting)this.addSetting(new BooleanIOSetting("NamespacedOutput", IOSetting.Importance.LOW, "Should the output use namespaced output?", "true"));
        this.namespacePrefix = (StringIOSetting)this.addSetting(new StringIOSetting("NamespacePrefix", IOSetting.Importance.LOW, "What should the namespace prefix be? [empty is no prefix]", ""));
        this.schemaInstanceOutput = (BooleanIOSetting)this.addSetting(new BooleanIOSetting("SchemaInstance", IOSetting.Importance.LOW, "Should the output use the Schema-Instance attribute?", "false"));
        this.instanceLocation = (StringIOSetting)this.addSetting(new StringIOSetting("InstanceLocation", IOSetting.Importance.LOW, "Where is the schema found?", ""));
        this.indent = (BooleanIOSetting)this.addSetting(new BooleanIOSetting("Indenting", IOSetting.Importance.LOW, "Should the output be indented?", "true"));
        this.xmlDeclaration = (BooleanIOSetting)this.addSetting(new BooleanIOSetting("XMLDeclaration", IOSetting.Importance.LOW, "Should the output contain an XML declaration?", "true"));
    }

    private void customizeJob() {
        this.fireIOSettingQuestion(this.cmlIds);
        this.fireIOSettingQuestion(this.namespacedOutput);
        if (this.namespacedOutput.isSet()) {
            this.fireIOSettingQuestion(this.namespacePrefix);
        }
        this.fireIOSettingQuestion(this.schemaInstanceOutput);
        if (this.schemaInstanceOutput.isSet()) {
            this.fireIOSettingQuestion(this.instanceLocation);
        }
        this.fireIOSettingQuestion(this.indent);
        this.fireIOSettingQuestion(this.xmlDeclaration);
    }
}

