/*
 * Decompiled with CFR 0.152.
 */
package org.openscience.cdk.renderer.generators;

import java.awt.Color;
import java.util.Arrays;
import java.util.List;
import javax.vecmath.Point2d;
import org.openscience.cdk.annotations.TestClass;
import org.openscience.cdk.annotations.TestMethod;
import org.openscience.cdk.geometry.GeometryTools;
import org.openscience.cdk.interfaces.IAtom;
import org.openscience.cdk.interfaces.IAtomContainer;
import org.openscience.cdk.interfaces.IPseudoAtom;
import org.openscience.cdk.renderer.RendererModel;
import org.openscience.cdk.renderer.color.CDK2DAtomColors;
import org.openscience.cdk.renderer.color.IAtomColorer;
import org.openscience.cdk.renderer.elements.AtomSymbolElement;
import org.openscience.cdk.renderer.elements.ElementGroup;
import org.openscience.cdk.renderer.elements.IRenderingElement;
import org.openscience.cdk.renderer.elements.OvalElement;
import org.openscience.cdk.renderer.elements.RectangleElement;
import org.openscience.cdk.renderer.generators.BasicSceneGenerator;
import org.openscience.cdk.renderer.generators.IGenerator;
import org.openscience.cdk.renderer.generators.IGeneratorParameter;
import org.openscience.cdk.renderer.generators.parameter.AbstractGeneratorParameter;
import org.openscience.cdk.validate.ProblemMarker;

@TestClass(value="org.openscience.cdk.renderer.generators.BasicAtomGeneratorTest")
public class BasicAtomGenerator
implements IGenerator<IAtomContainer> {
    private IGeneratorParameter<Color> atomColor = new AtomColor();
    private IGeneratorParameter<IAtomColorer> atomColorer = new AtomColorer();
    private IGeneratorParameter<Boolean> colorByType = new ColorByType();
    private IGeneratorParameter<Boolean> showExplicitHydrogens = new ShowExplicitHydrogens();
    private IGeneratorParameter<Double> atomRadius = new AtomRadius();
    private IGeneratorParameter<Boolean> isCompact = new CompactAtom();
    private IGeneratorParameter<Boolean> isKekule = new KekuleStructure();
    private IGeneratorParameter<Shape> compactShape = new CompactShape();
    private IGeneratorParameter<Boolean> showEndCarbons = new ShowEndCarbons();

    @Override
    @TestMethod(value="testSingleBond,testSquare")
    public IRenderingElement generate(IAtomContainer container, RendererModel model) {
        ElementGroup elementGroup = new ElementGroup();
        for (IAtom atom : container.atoms()) {
            elementGroup.add(this.generate(container, atom, model));
        }
        return elementGroup;
    }

    @TestMethod(value="hasCoordinatesTest")
    protected boolean hasCoordinates(IAtom atom) {
        return atom != null && atom.getPoint2d() != null;
    }

    protected boolean isHydrogen(IAtom atom) {
        return "H".equals(atom.getSymbol());
    }

    private boolean isCarbon(IAtom atom) {
        return "C".equals(atom.getSymbol());
    }

    @TestMethod(value="invisibleHydrogenTest")
    protected boolean invisibleHydrogen(IAtom atom, RendererModel model) {
        return this.isHydrogen(atom) && (Boolean)model.get(ShowExplicitHydrogens.class) == false;
    }

    @TestMethod(value="invisibleCarbonTest")
    protected boolean invisibleCarbon(IAtom atom, IAtomContainer atomContainer, RendererModel model) {
        return this.isCarbon(atom) && !this.showCarbon(atom, atomContainer, model);
    }

    @TestMethod(value="canDrawTest")
    protected boolean canDraw(IAtom atom, IAtomContainer container, RendererModel model) {
        if (!this.hasCoordinates(atom)) {
            return false;
        }
        if (this.invisibleHydrogen(atom, model)) {
            return false;
        }
        return !this.invisibleCarbon(atom, container, model);
    }

    @TestMethod(value="testSingleAtom")
    public IRenderingElement generate(IAtomContainer atomContainer, IAtom atom, RendererModel model) {
        if (!this.canDraw(atom, atomContainer, model)) {
            return null;
        }
        if (((Boolean)model.get(CompactAtom.class)).booleanValue()) {
            return this.generateCompactElement(atom, model);
        }
        int alignment = 0;
        alignment = atom.getSymbol().equals("C") ? GeometryTools.getBestAlignmentForLabel(atomContainer, atom) : GeometryTools.getBestAlignmentForLabelXY(atomContainer, atom);
        return this.generateElement(atom, alignment, model);
    }

    @TestMethod(value="ovalShapeTest,squareShapeTest")
    public IRenderingElement generateCompactElement(IAtom atom, RendererModel model) {
        Point2d point = atom.getPoint2d();
        double radius = (Double)model.get(AtomRadius.class) / (Double)model.getParameter(BasicSceneGenerator.Scale.class).getValue();
        double distance = 2.0 * radius;
        if (model.get(CompactShape.class) == Shape.SQUARE) {
            return new RectangleElement(point.x - radius, point.y - radius, distance, distance, true, this.getAtomColor(atom, model));
        }
        return new OvalElement(point.x, point.y, radius, true, this.getAtomColor(atom, model));
    }

    @TestMethod(value="generateElementTest")
    public AtomSymbolElement generateElement(IAtom atom, int alignment, RendererModel model) {
        String text = atom instanceof IPseudoAtom ? ((IPseudoAtom)atom).getLabel() : atom.getSymbol();
        return new AtomSymbolElement(atom.getPoint2d().x, atom.getPoint2d().y, text, atom.getFormalCharge(), atom.getImplicitHydrogenCount(), alignment, this.getAtomColor(atom, model));
    }

    @TestMethod(value="showCarbon_KekuleTest,showCarbon_FormalChargeTest,showCarbon_SingleCarbonTest,showCarbon_ShowEndCarbonsTest,showCarbon_ErrorMarker,showCarbon_ConnectedSingleElectrons")
    protected boolean showCarbon(IAtom carbonAtom, IAtomContainer container, RendererModel model) {
        if (((Boolean)model.get(KekuleStructure.class)).booleanValue()) {
            return true;
        }
        if (carbonAtom.getFormalCharge() != 0) {
            return true;
        }
        int connectedBondCount = container.getConnectedBondsList(carbonAtom).size();
        if (connectedBondCount < 1) {
            return true;
        }
        if (((Boolean)model.get(ShowEndCarbons.class)).booleanValue() && connectedBondCount == 1) {
            return true;
        }
        if (carbonAtom.getProperty(ProblemMarker.ERROR_MARKER) != null) {
            return true;
        }
        return container.getConnectedSingleElectronsCount(carbonAtom) > 0;
    }

    @TestMethod(value="getAtomColorTest")
    protected Color getAtomColor(IAtom atom, RendererModel model) {
        Color atomColor = (Color)model.get(AtomColor.class);
        if (((Boolean)model.get(ColorByType.class)).booleanValue()) {
            atomColor = ((IAtomColorer)model.get(AtomColorer.class)).getAtomColor(atom);
        }
        return atomColor;
    }

    @Override
    @TestMethod(value="getParametersTest")
    public List<IGeneratorParameter<?>> getParameters() {
        return Arrays.asList(this.atomColor, this.atomColorer, this.atomRadius, this.colorByType, this.compactShape, this.isCompact, this.isKekule, this.showEndCarbons, this.showExplicitHydrogens);
    }

    public static class ShowEndCarbons
    extends AbstractGeneratorParameter<Boolean> {
        @Override
        public Boolean getDefault() {
            return Boolean.FALSE;
        }
    }

    public static class CompactShape
    extends AbstractGeneratorParameter<Shape> {
        @Override
        public Shape getDefault() {
            return Shape.SQUARE;
        }
    }

    public static enum Shape {
        OVAL,
        SQUARE;

    }

    public static class KekuleStructure
    extends AbstractGeneratorParameter<Boolean> {
        @Override
        public Boolean getDefault() {
            return Boolean.FALSE;
        }
    }

    public static class CompactAtom
    extends AbstractGeneratorParameter<Boolean> {
        @Override
        public Boolean getDefault() {
            return Boolean.FALSE;
        }
    }

    public static class AtomRadius
    extends AbstractGeneratorParameter<Double> {
        @Override
        public Double getDefault() {
            return 8.0;
        }
    }

    public static class ShowExplicitHydrogens
    extends AbstractGeneratorParameter<Boolean> {
        @Override
        public Boolean getDefault() {
            return Boolean.TRUE;
        }
    }

    public static class ColorByType
    extends AbstractGeneratorParameter<Boolean> {
        @Override
        public Boolean getDefault() {
            return Boolean.TRUE;
        }
    }

    public static class AtomColorer
    extends AbstractGeneratorParameter<IAtomColorer> {
        @Override
        public IAtomColorer getDefault() {
            return new CDK2DAtomColors();
        }
    }

    public static class AtomColor
    extends AbstractGeneratorParameter<Color> {
        @Override
        public Color getDefault() {
            return Color.BLACK;
        }
    }
}

