/*
 * Decompiled with CFR 0.152.
 */
package org.openscience.cdk.reaction.mechanism;

import java.util.ArrayList;
import java.util.List;
import org.openscience.cdk.DefaultChemObjectBuilder;
import org.openscience.cdk.SingleElectron;
import org.openscience.cdk.annotations.TestClass;
import org.openscience.cdk.annotations.TestMethod;
import org.openscience.cdk.atomtype.CDKAtomTypeMatcher;
import org.openscience.cdk.exception.CDKException;
import org.openscience.cdk.interfaces.IAtom;
import org.openscience.cdk.interfaces.IAtomType;
import org.openscience.cdk.interfaces.IBond;
import org.openscience.cdk.interfaces.ILonePair;
import org.openscience.cdk.interfaces.IMapping;
import org.openscience.cdk.interfaces.IMolecule;
import org.openscience.cdk.interfaces.IMoleculeSet;
import org.openscience.cdk.interfaces.IReaction;
import org.openscience.cdk.reaction.IReactionMechanism;
import org.openscience.cdk.tools.manipulator.AtomContainerManipulator;

@TestClass(value="org.openscience.cdk.reaction.mechanism.RemovingSEofNBMechanismTest")
public class RemovingSEofNBMechanism
implements IReactionMechanism {
    @Override
    @TestMethod(value="testInitiate_IMoleculeSet_ArrayList_ArrayList")
    public IReaction initiate(IMoleculeSet moleculeSet, ArrayList<IAtom> atomList, ArrayList<IBond> bondList) throws CDKException {
        IMolecule reactantCloned;
        CDKAtomTypeMatcher atMatcher = CDKAtomTypeMatcher.getInstance(moleculeSet.getBuilder());
        if (moleculeSet.getMoleculeCount() != 1) {
            throw new CDKException("RemovingSEofNBMechanism only expects one IMolecule");
        }
        if (atomList.size() != 1) {
            throw new CDKException("RemovingSEofNBMechanism only expects one atom in the ArrayList");
        }
        if (bondList != null) {
            throw new CDKException("RemovingSEofNBMechanism don't expect any bond in the ArrayList");
        }
        IMolecule molecule = moleculeSet.getMolecule(0);
        try {
            reactantCloned = (IMolecule)molecule.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new CDKException("Could not clone IMolecule!", e);
        }
        int posAtom = molecule.getAtomNumber(atomList.get(0));
        List<ILonePair> lps = reactantCloned.getConnectedLonePairsList(reactantCloned.getAtom(posAtom));
        reactantCloned.removeLonePair(lps.get(lps.size() - 1));
        reactantCloned.addSingleElectron(new SingleElectron(reactantCloned.getAtom(posAtom)));
        int charge = reactantCloned.getAtom(posAtom).getFormalCharge();
        reactantCloned.getAtom(posAtom).setFormalCharge(charge + 1);
        reactantCloned.getAtom(posAtom).setHybridization(null);
        AtomContainerManipulator.percieveAtomTypesAndConfigureAtoms(reactantCloned);
        IAtomType type = atMatcher.findMatchingAtomType(reactantCloned, reactantCloned.getAtom(posAtom));
        if (type == null) {
            return null;
        }
        IReaction reaction = DefaultChemObjectBuilder.getInstance().newInstance(IReaction.class, new Object[0]);
        reaction.addReactant(molecule);
        for (IAtom atom : molecule.atoms()) {
            IMapping mapping = DefaultChemObjectBuilder.getInstance().newInstance(IMapping.class, atom, reactantCloned.getAtom(molecule.getAtomNumber(atom)));
            reaction.addMapping(mapping);
        }
        reaction.addProduct(reactantCloned);
        return reaction;
    }
}

