/*
 * Decompiled with CFR 0.152.
 */
package org.openscience.cdk.smsd.algorithm.mcsplus;

import java.util.ArrayList;
import java.util.List;
import java.util.Stack;
import org.openscience.cdk.annotations.TestClass;
import org.openscience.cdk.smsd.algorithm.mcsplus.MCSPlus;
import org.openscience.cdk.smsd.tools.TimeManager;

@TestClass(value="org.openscience.cdk.smsd.SMSDBondSensitiveTest")
public class BKKCKCF {
    private List<List<Integer>> maxCliquesSet = null;
    private List<Integer> cEdges = null;
    private List<Integer> dEdges = null;
    private int bestCliqueSize = 0;
    private List<Integer> compGraphNodes = null;
    private double dEdgeIterationSize = 0.0;
    private double cEdgeIterationSize = 0.0;

    protected BKKCKCF(List<Integer> comp_graph_nodes_org, List<Integer> C_edges_org, List<Integer> D_edges_org) {
        MCSPlus.setTimeManager(new TimeManager());
        this.compGraphNodes = comp_graph_nodes_org;
        this.cEdges = C_edges_org;
        this.dEdges = D_edges_org;
        this.bestCliqueSize = 0;
        this.dEdgeIterationSize = this.dEdges.size() / 2;
        this.cEdgeIterationSize = this.cEdges.size() / 2;
        this.maxCliquesSet = new ArrayList<List<Integer>>();
        this.init();
    }

    private void init() {
        ArrayList<Integer> vertex = new ArrayList<Integer>();
        int vertexCount = this.compGraphNodes.size() / 3;
        for (int a = 0; a < vertexCount; ++a) {
            vertex.add(this.compGraphNodes.get(a * 3 + 2));
        }
        vertex.add(0);
        ArrayList<Integer> processedVertex = new ArrayList<Integer>();
        this.initIterator(vertex, processedVertex);
        processedVertex.clear();
    }

    private int enumerateCliques(List<Integer> vertexOfCurrentClique, Stack<Integer> potentialCVertex, List<Integer> potentialDVertex, List<Integer> excludedVertex, List<Integer> excludedCVertex) {
        ArrayList<Integer> potentialVertex = new ArrayList<Integer>();
        for (Integer I : potentialCVertex) {
            potentialVertex.add(I);
        }
        if (potentialCVertex.size() == 1 && excludedVertex.isEmpty()) {
            int clique_size = vertexOfCurrentClique.size();
            if (clique_size >= this.bestCliqueSize) {
                if (clique_size > this.bestCliqueSize) {
                    this.maxCliquesSet.clear();
                    this.bestCliqueSize = clique_size;
                }
                if (clique_size == this.bestCliqueSize) {
                    this.maxCliquesSet.add(vertexOfCurrentClique);
                }
            }
            return 0;
        }
        this.findCliques(potentialVertex, vertexOfCurrentClique, potentialCVertex, potentialDVertex, excludedVertex, excludedCVertex);
        return 0;
    }

    private List<Integer> findNeighbors(int central_node) {
        ArrayList<Integer> neighborVertex = new ArrayList<Integer>();
        int a = 0;
        while ((double)a < this.cEdgeIterationSize) {
            if (this.cEdges.get(a * 2 + 0) == central_node) {
                neighborVertex.add(this.cEdges.get(a * 2 + 1));
                neighborVertex.add(1);
            } else if (this.cEdges.get(a * 2 + 1) == central_node) {
                neighborVertex.add(this.cEdges.get(a * 2 + 0));
                neighborVertex.add(1);
            }
            ++a;
        }
        a = 0;
        while ((double)a < this.dEdgeIterationSize) {
            if (this.dEdges.get(a * 2 + 0) == central_node) {
                neighborVertex.add(this.dEdges.get(a * 2 + 1));
                neighborVertex.add(2);
            } else if (this.dEdges.get(a * 2 + 1) == central_node) {
                neighborVertex.add(this.dEdges.get(a * 2 + 0));
                neighborVertex.add(2);
            }
            ++a;
        }
        return neighborVertex;
    }

    protected int getBestCliqueSize() {
        return this.bestCliqueSize;
    }

    protected Stack<List<Integer>> getMaxCliqueSet() {
        Stack<List<Integer>> solution = new Stack<List<Integer>>();
        solution.addAll(this.maxCliquesSet);
        return solution;
    }

    private void findCliques(List<Integer> potentialVertex, List<Integer> vertexOfCurrentClique, Stack<Integer> potentialCVertex, List<Integer> potentialDVertex, List<Integer> excludedVertex, List<Integer> excludedCVertex) {
        int index = 0;
        ArrayList<Integer> neighbourVertex = new ArrayList();
        while (potentialVertex.get(index) != 0) {
            int potentialVertexIndex = potentialVertex.get(index);
            potentialCVertex.removeElement(potentialVertexIndex);
            ArrayList<Integer> R_copy = new ArrayList<Integer>(vertexOfCurrentClique);
            Stack<Integer> P_copy = new Stack<Integer>();
            ArrayList<Integer> Q_copy = new ArrayList<Integer>(potentialDVertex);
            ArrayList<Integer> X_copy = new ArrayList<Integer>(excludedVertex);
            ArrayList<Integer> Y_copy = new ArrayList<Integer>(excludedCVertex);
            neighbourVertex.clear();
            for (Integer obj : potentialCVertex) {
                P_copy.add(obj);
            }
            P_copy.pop();
            neighbourVertex = this.findNeighbors(potentialVertexIndex);
            this.groupNeighbors(index, P_copy, Q_copy, X_copy, Y_copy, neighbourVertex, potentialDVertex, potentialVertex, excludedVertex, excludedCVertex);
            Stack<Integer> P_copy_N_intersec = new Stack<Integer>();
            ArrayList<Integer> Q_copy_N_intersec = new ArrayList<Integer>();
            ArrayList<Integer> X_copy_N_intersec = new ArrayList<Integer>();
            ArrayList<Integer> Y_copy_N_intersec = new ArrayList<Integer>();
            this.copyVertex(neighbourVertex, P_copy_N_intersec, P_copy, Q_copy_N_intersec, Q_copy, X_copy_N_intersec, X_copy, Y_copy_N_intersec, Y_copy);
            P_copy_N_intersec.push(0);
            R_copy.add(potentialVertexIndex);
            this.enumerateCliques(R_copy, P_copy_N_intersec, Q_copy_N_intersec, X_copy_N_intersec, Y_copy_N_intersec);
            excludedVertex.add(potentialVertexIndex);
            ++index;
        }
    }

    private void copyVertex(List<Integer> neighbourVertex, Stack<Integer> P_copy_N_intersec, Stack<Integer> P_copy, List<Integer> Q_copy_N_intersec, List<Integer> Q_copy, List<Integer> X_copy_N_intersec, List<Integer> X_copy, List<Integer> Y_copy_N_intersec, List<Integer> Y_copy) {
        int nElement = -1;
        int N_size = neighbourVertex.size();
        for (int sec = 0; sec < N_size; sec += 2) {
            nElement = neighbourVertex.get(sec);
            if (P_copy.contains(nElement)) {
                P_copy_N_intersec.push(nElement);
            }
            if (Q_copy.contains(nElement)) {
                Q_copy_N_intersec.add(nElement);
            }
            if (X_copy.contains(nElement)) {
                X_copy_N_intersec.add(nElement);
            }
            if (!Y_copy.contains(nElement)) continue;
            Y_copy_N_intersec.add(nElement);
        }
    }

    private void groupNeighbors(int index, Stack<Integer> P_copy, List<Integer> Q_copy, List<Integer> X_copy, List<Integer> Y_copy, List<Integer> neighbourVertex, List<Integer> potentialDVertex, List<Integer> potentialVertex, List<Integer> excludedVertex, List<Integer> excludedCVertex) {
        int N_size = neighbourVertex.size();
        for (int b = 0; b < N_size; b += 2) {
            Integer Nelement_at_b = neighbourVertex.get(b);
            if (neighbourVertex.get(b + 1) == 1) {
                if (potentialDVertex.contains(Nelement_at_b)) {
                    P_copy.push(Nelement_at_b);
                    Q_copy.remove(Nelement_at_b);
                }
                if (excludedCVertex.contains(Nelement_at_b)) {
                    if (excludedVertex.contains(Nelement_at_b)) {
                        X_copy.add(Nelement_at_b);
                    }
                    Y_copy.remove(Nelement_at_b);
                }
            }
            if (potentialVertex.indexOf(Nelement_at_b) <= index && potentialVertex.indexOf(Nelement_at_b) > -1) {
                --index;
            }
            potentialVertex.remove(Nelement_at_b);
        }
    }

    private void setEdges() {
        boolean d_edgeFlag = false;
        if (this.dEdges.size() > this.cEdges.size()) {
            if (this.dEdges.size() > 10000000 && this.cEdges.size() > 100000) {
                this.dEdgeIterationSize = (double)this.dEdges.size() * 1.0E-6;
                d_edgeFlag = true;
            } else if (this.dEdges.size() > 10000000 && this.cEdges.size() > 5000) {
                this.dEdgeIterationSize = (double)this.dEdges.size() * 0.001;
                d_edgeFlag = true;
            }
        }
        if (d_edgeFlag) {
            this.checkLowestEdgeCount();
        }
    }

    private void initIterator(List<Integer> vertex, List<Integer> processedVertex) {
        ArrayList<Integer> vertexOfCurrentClique = new ArrayList<Integer>();
        Stack<Integer> potentialCVertex = new Stack<Integer>();
        ArrayList<Integer> potentialDVertex = new ArrayList<Integer>();
        ArrayList<Integer> excludedVertex = new ArrayList<Integer>();
        ArrayList<Integer> excludedCVertex = new ArrayList<Integer>();
        List<Object> neighbourVertex = new ArrayList();
        int index = 0;
        while (vertex.get(index) != 0) {
            int central_node = vertex.get(index);
            potentialCVertex.clear();
            potentialDVertex.clear();
            excludedVertex.clear();
            vertexOfCurrentClique.clear();
            neighbourVertex = this.findNeighbors(central_node);
            for (int c = 0; c < neighbourVertex.size(); c += 2) {
                Integer neighbourVertexOfC = (Integer)neighbourVertex.get(c);
                if ((Integer)neighbourVertex.get(c + 1) == 1) {
                    if (processedVertex.contains(neighbourVertexOfC)) {
                        excludedVertex.add(neighbourVertexOfC);
                    } else {
                        potentialCVertex.push(neighbourVertexOfC);
                    }
                } else if ((Integer)neighbourVertex.get(c + 1) == 2) {
                    if (processedVertex.contains(neighbourVertexOfC)) {
                        excludedCVertex.add(neighbourVertexOfC);
                    } else {
                        potentialDVertex.add(neighbourVertexOfC);
                    }
                }
                if (vertex.indexOf(neighbourVertexOfC) <= index && vertex.indexOf(neighbourVertexOfC) > -1) {
                    --index;
                }
                vertex.remove(neighbourVertexOfC);
            }
            potentialCVertex.add(0);
            vertexOfCurrentClique.add(central_node);
            this.enumerateCliques(vertexOfCurrentClique, potentialCVertex, potentialDVertex, excludedVertex, excludedCVertex);
            processedVertex.add(central_node);
            ++index;
        }
    }

    private void checkLowestEdgeCount() {
        if (this.dEdgeIterationSize < 1.0 && this.cEdges.size() <= 5000) {
            this.dEdgeIterationSize = 2.0;
        } else if (this.dEdgeIterationSize < 1.0) {
            this.dEdgeIterationSize = 1.0;
        }
    }
}

