/*
 * Decompiled with CFR 0.152.
 */
package org.openscience.cdk.qsar.descriptors.molecular;

import java.util.ArrayList;
import org.openscience.cdk.annotations.TestClass;
import org.openscience.cdk.annotations.TestMethod;
import org.openscience.cdk.exception.CDKException;
import org.openscience.cdk.interfaces.IAtom;
import org.openscience.cdk.interfaces.IAtomContainer;
import org.openscience.cdk.interfaces.IBond;
import org.openscience.cdk.qsar.DescriptorSpecification;
import org.openscience.cdk.qsar.DescriptorValue;
import org.openscience.cdk.qsar.IMolecularDescriptor;
import org.openscience.cdk.qsar.result.DoubleArrayResult;
import org.openscience.cdk.qsar.result.DoubleResult;
import org.openscience.cdk.qsar.result.DoubleResultType;
import org.openscience.cdk.qsar.result.IDescriptorResult;
import org.openscience.cdk.tools.IonizationPotentialTool;
import org.openscience.cdk.tools.LonePairElectronChecker;

@TestClass(value="org.openscience.cdk.qsar.descriptors.molecular.IPMolecularLearningDescriptorTest")
public class IPMolecularLearningDescriptor
implements IMolecularDescriptor {
    private boolean addlp = true;
    private static final String[] names = new String[]{"MolIP"};

    @Override
    @TestMethod(value="testGetSpecification")
    public DescriptorSpecification getSpecification() {
        return new DescriptorSpecification("http://www.blueobelisk.org/ontologies/chemoinformatics-algorithms/#ip", this.getClass().getName(), "$Id: IPMolecularLearningDescriptor.java 10995 2008-05-14 14:38:21Z miguelrojasch $", "The Chemistry Development Kit");
    }

    @Override
    @TestMethod(value="testSetParameters_arrayObject")
    public void setParameters(Object[] params) throws CDKException {
        if (params.length != 1) {
            throw new CDKException("One parameter expected");
        }
        if (!(params[0] instanceof Boolean)) {
            throw new CDKException("Boolean parameter expected");
        }
        this.addlp = (Boolean)params[0];
    }

    @Override
    @TestMethod(value="testGetParameters")
    public Object[] getParameters() {
        return new Object[]{this.addlp};
    }

    @Override
    @TestMethod(value="testNamesConsistency")
    public String[] getDescriptorNames() {
        return names;
    }

    @Override
    @TestMethod(value="testCalculate_IAtomContainer")
    public DescriptorValue calculate(IAtomContainer atomContainer) {
        DoubleResult value;
        IAtomContainer local;
        if (this.addlp) {
            try {
                local = (IAtomContainer)atomContainer.clone();
                LonePairElectronChecker lpcheck = new LonePairElectronChecker();
                lpcheck.saturate(local);
            }
            catch (CloneNotSupportedException e) {
                return new DescriptorValue(this.getSpecification(), this.getParameterNames(), this.getParameters(), new DoubleResult(Double.NaN), this.getDescriptorNames(), e);
            }
            catch (CDKException e) {
                return new DescriptorValue(this.getSpecification(), this.getParameterNames(), this.getParameters(), new DoubleResult(Double.NaN), this.getDescriptorNames(), e);
            }
        } else {
            local = atomContainer;
        }
        try {
            value = new DoubleResult(((DoubleArrayResult)this.calculatePlus(local).getValue()).get(0));
        }
        catch (CDKException e) {
            return new DescriptorValue(this.getSpecification(), this.getParameterNames(), this.getParameters(), new DoubleResult(Double.NaN), this.getDescriptorNames(), e);
        }
        return new DescriptorValue(this.getSpecification(), this.getParameterNames(), this.getParameters(), value, this.getDescriptorNames());
    }

    @TestMethod(value="testIPDescriptor_2,testIPDescriptor_3")
    public DescriptorValue calculatePlus(IAtomContainer container) throws CDKException {
        double value;
        ArrayList<Double> dar = new ArrayList<Double>();
        for (IAtom atom : container.atoms()) {
            value = IonizationPotentialTool.predictIP(container, atom);
            if (value == 0.0) continue;
            dar.add(value);
        }
        for (IBond bond : container.bonds()) {
            if (!(bond.getOrder() == IBond.Order.DOUBLE & bond.getAtom(0).getSymbol().equals("C") & bond.getAtom(1).getSymbol().equals("C")) || (value = IonizationPotentialTool.predictIP(container, bond)) == 0.0) continue;
            dar.add(value);
        }
        DoubleArrayResult results = this.arrangingEnergy(dar);
        return new DescriptorValue(this.getSpecification(), this.getParameterNames(), this.getParameters(), results, this.getDescriptorNames(), null);
    }

    private DoubleArrayResult arrangingEnergy(ArrayList<Double> array) {
        DoubleArrayResult results = new DoubleArrayResult();
        int count = array.size();
        for (int i = 0; i < count; ++i) {
            double min = array.get(0);
            int pos = 0;
            for (int j = 0; j < array.size(); ++j) {
                double value = array.get(j);
                if (!(value < min)) continue;
                min = value;
                pos = j;
            }
            array.remove(pos);
            results.add(min);
        }
        return results;
    }

    @Override
    @TestMethod(value="testGetDescriptorResultType")
    public IDescriptorResult getDescriptorResultType() {
        return new DoubleResultType();
    }

    @Override
    @TestMethod(value="testGetParameterNames")
    public String[] getParameterNames() {
        return new String[]{"addlp"};
    }

    @Override
    @TestMethod(value="testGetParameterType_String")
    public Object getParameterType(String name) {
        return this.addlp;
    }
}

