/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.printing;

import org.eclipse.swt.SWT;
import org.eclipse.swt.internal.Callback;
import org.eclipse.swt.internal.Converter;
import org.eclipse.swt.internal.LONG;
import org.eclipse.swt.internal.gtk.OS;
import org.eclipse.swt.printing.Printer;
import org.eclipse.swt.printing.PrinterData;
import org.eclipse.swt.widgets.Dialog;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;

public class PrintDialog
extends Dialog {
    PrinterData printerData;
    int scope = 0;
    int startPage = 1;
    int endPage = 1;
    boolean printToFile = false;
    long handle;
    int index;
    byte[] settingsData;
    static final String GET_MODAL_DIALOG = "org.eclipse.swt.internal.gtk.getModalDialog";
    static final String SET_MODAL_DIALOG = "org.eclipse.swt.internal.gtk.setModalDialog";
    static final String ADD_IDLE_PROC_KEY = "org.eclipse.swt.internal.gtk.addIdleProc";
    static final String REMOVE_IDLE_PROC_KEY = "org.eclipse.swt.internal.gtk.removeIdleProc";
    static final String GET_EMISSION_PROC_KEY = "org.eclipse.swt.internal.gtk.getEmissionProc";

    public PrintDialog(Shell shell) {
        this(shell, 32768);
    }

    public PrintDialog(Shell shell, int n) {
        super(shell, shell == null ? n : PrintDialog.checkStyleBit(shell, n));
        this.checkSubclass();
    }

    public void setPrinterData(PrinterData printerData) {
        this.printerData = printerData;
    }

    public PrinterData getPrinterData() {
        return this.printerData;
    }

    static int checkBits(int n, int n2, int n3, int n4, int n5, int n6, int n7) {
        int n8 = n2 | n3 | n4 | n5 | n6 | n7;
        if ((n & n8) == 0) {
            n |= n2;
        }
        if ((n & n2) != 0) {
            n = n & ~n8 | n2;
        }
        if ((n & n3) != 0) {
            n = n & ~n8 | n3;
        }
        if ((n & n4) != 0) {
            n = n & ~n8 | n4;
        }
        if ((n & n5) != 0) {
            n = n & ~n8 | n5;
        }
        if ((n & n6) != 0) {
            n = n & ~n8 | n6;
        }
        if ((n & n7) != 0) {
            n = n & ~n8 | n7;
        }
        return n;
    }

    static int checkStyleBit(Shell shell, int n) {
        if (((n &= 0xF7FFFFFF) & 0x6000000) == 0 && shell != null) {
            if ((shell.getStyle() & 0x2000000) != 0) {
                n |= 0x2000000;
            }
            if ((shell.getStyle() & 0x4000000) != 0) {
                n |= 0x4000000;
            }
        }
        return PrintDialog.checkBits(n, 0x2000000, 0x4000000, 0, 0, 0, 0);
    }

    @Override
    protected void checkSubclass() {
    }

    public int getScope() {
        return this.scope;
    }

    public void setScope(int n) {
        this.scope = n;
    }

    public int getStartPage() {
        return this.startPage;
    }

    public void setStartPage(int n) {
        this.startPage = n;
    }

    public int getEndPage() {
        return this.endPage;
    }

    public void setEndPage(int n) {
        this.endPage = n;
    }

    public boolean getPrintToFile() {
        return this.printToFile;
    }

    public void setPrintToFile(boolean bl) {
        this.printToFile = bl;
    }

    public PrinterData open() {
        long l;
        Object object;
        if (OS.GTK_VERSION < OS.VERSION(2, 10, 0)) {
            return Printer.getDefaultPrinterData();
        }
        byte[] byArray = Converter.wcsToMbcs(null, this.getText(), true);
        long l2 = this.getParent().handle;
        while (l2 != 0L && !OS.GTK_IS_WINDOW(l2)) {
            l2 = OS.gtk_widget_get_parent(l2);
        }
        this.handle = OS.gtk_print_unix_dialog_new(byArray, l2);
        OS.gtk_print_unix_dialog_set_current_page(this.handle, -1);
        OS.gtk_print_unix_dialog_set_manual_capabilities(this.handle, 7L);
        long l3 = OS.gtk_print_settings_new();
        long l4 = OS.gtk_page_setup_new();
        if (this.printerData != null) {
            if (this.printerData.otherData != null) {
                Printer.restore(this.printerData.otherData, l3, l4);
            }
            Printer.setScope(l3, this.printerData.scope, this.printerData.startPage, this.printerData.endPage);
            if (this.printerData.printToFile) {
                object = Converter.wcsToMbcs(null, this.printerData.fileName, true);
                OS.gtk_print_settings_set(l3, OS.GTK_PRINT_SETTINGS_OUTPUT_URI, object);
            }
            if (this.printerData.driver.equals("GtkPrintBackendFile") && this.printerData.name.equals("Print to File")) {
                object = Converter.wcsToMbcs(null, this.printerData.fileName, true);
                OS.gtk_print_settings_set(l3, OS.GTK_PRINT_SETTINGS_OUTPUT_URI, object);
            }
            OS.gtk_print_settings_set_n_copies(l3, this.printerData.copyCount);
            OS.gtk_print_settings_set_collate(l3, this.printerData.collate);
        }
        Printer.setScope(l3, this.scope, this.startPage, this.endPage);
        if (this.printToFile) {
            object = Converter.wcsToMbcs(null, "Print to File", true);
            OS.gtk_print_settings_set_printer(l3, object);
        }
        OS.gtk_print_unix_dialog_set_settings(this.handle, l3);
        OS.gtk_print_unix_dialog_set_page_setup(this.handle, l4);
        OS.g_object_unref(l3);
        OS.g_object_unref(l4);
        object = null;
        Display display = this.getParent() != null ? this.getParent().getDisplay() : Display.getCurrent();
        int n = 0;
        long l5 = 0L;
        if ((this.getStyle() & 0x4000000) != 0) {
            n = OS.g_signal_lookup(OS.map, OS.GTK_TYPE_WIDGET());
            l5 = OS.g_signal_add_emission_hook(n, 0, ((LONG)display.getData((String)GET_EMISSION_PROC_KEY)).value, this.handle, 0L);
        }
        display.setData(ADD_IDLE_PROC_KEY, null);
        Object object2 = null;
        if (OS.gtk_window_get_modal(this.handle)) {
            object2 = display.getData(GET_MODAL_DIALOG);
            display.setData(SET_MODAL_DIALOG, this);
        }
        int n2 = OS.gtk_dialog_run(this.handle);
        if (OS.gtk_window_get_modal(this.handle)) {
            display.setData(SET_MODAL_DIALOG, object2);
        }
        if ((this.getStyle() & 0x4000000) != 0) {
            OS.g_signal_remove_emission_hook(n, l5);
        }
        if (n2 == -5 && (l = OS.gtk_print_unix_dialog_get_selected_printer(this.handle)) != 0L) {
            Object[] objectArray;
            long l6;
            Object object3;
            l3 = OS.gtk_print_unix_dialog_get_settings(this.handle);
            l4 = OS.gtk_print_unix_dialog_get_page_setup(this.handle);
            object = Printer.printerDataFromGtkPrinter(l);
            int n3 = OS.gtk_print_settings_get_print_pages(l3);
            switch (n3) {
                case 0: {
                    this.scope = 0;
                    break;
                }
                case 2: {
                    this.scope = 1;
                    object3 = new int[1];
                    l6 = OS.gtk_print_settings_get_page_ranges(l3, (int[])object3);
                    objectArray = new int[2];
                    int n4 = object3[0];
                    int n5 = Integer.MAX_VALUE;
                    int n6 = 0;
                    for (int i = 0; i < n4; ++i) {
                        OS.memmove(objectArray, l6 + (long)(i * objectArray.length * 4), (long)(objectArray.length * 4));
                        n5 = Math.min(n5, objectArray[0] + 1);
                        n6 = Math.max(n6, objectArray[1] + 1);
                    }
                    OS.g_free(l6);
                    this.startPage = n5 == Integer.MAX_VALUE ? 1 : n5;
                    this.endPage = n6 == 0 ? 1 : n6;
                    break;
                }
                case 1: {
                    this.scope = 2;
                    this.startPage = this.endPage = OS.gtk_print_unix_dialog_get_current_page(this.handle);
                }
            }
            this.printToFile = object.name.equals("Print to File");
            if (this.printToFile) {
                long l7 = OS.gtk_print_settings_get(l3, OS.GTK_PRINT_SETTINGS_OUTPUT_URI);
                int n7 = OS.strlen(l7);
                objectArray = new byte[n7];
                OS.memmove((byte[])objectArray, l7, (long)n7);
                object.fileName = new String(Converter.mbcsToWcs(null, (byte[])objectArray));
            }
            object.scope = this.scope;
            object.startPage = this.startPage;
            object.endPage = this.endPage;
            object.printToFile = this.printToFile;
            object.copyCount = OS.gtk_print_settings_get_n_copies(l3);
            object.collate = OS.gtk_print_settings_get_collate(l3);
            object3 = new Callback(this, "GtkPrintSettingsFunc", 3);
            l6 = ((Callback)object3).getAddress();
            if (l6 == 0L) {
                SWT.error(3);
            }
            this.index = 0;
            this.settingsData = new byte[1024];
            OS.gtk_print_settings_foreach(l3, l6, 0L);
            ((Callback)object3).dispose();
            ++this.index;
            this.store("orientation", OS.gtk_page_setup_get_orientation(l4));
            this.store("top_margin", OS.gtk_page_setup_get_top_margin(l4, 3));
            this.store("bottom_margin", OS.gtk_page_setup_get_bottom_margin(l4, 3));
            this.store("left_margin", OS.gtk_page_setup_get_left_margin(l4, 3));
            this.store("right_margin", OS.gtk_page_setup_get_right_margin(l4, 3));
            long l8 = OS.gtk_page_setup_get_paper_size(l4);
            this.storeBytes("paper_size_name", OS.gtk_paper_size_get_name(l8));
            this.storeBytes("paper_size_display_name", OS.gtk_paper_size_get_display_name(l8));
            this.storeBytes("paper_size_ppd_name", OS.gtk_paper_size_get_ppd_name(l8));
            this.store("paper_size_width", OS.gtk_paper_size_get_width(l8, 3));
            this.store("paper_size_height", OS.gtk_paper_size_get_height(l8, 3));
            this.store("paper_size_is_custom", OS.gtk_paper_size_is_custom(l8));
            object.otherData = this.settingsData;
            OS.g_object_unref(l3);
        }
        display.setData(REMOVE_IDLE_PROC_KEY, null);
        OS.gtk_widget_destroy(this.handle);
        return object;
    }

    long GtkPrintSettingsFunc(long l, long l2, long l3) {
        int n = OS.strlen(l);
        byte[] byArray = new byte[n];
        OS.memmove(byArray, l, (long)n);
        n = OS.strlen(l2);
        byte[] byArray2 = new byte[n];
        OS.memmove(byArray2, l2, (long)n);
        this.store(byArray, byArray2);
        return 0L;
    }

    void store(String string, int n) {
        this.store(string, String.valueOf(n));
    }

    void store(String string, double d) {
        this.store(string, String.valueOf(d));
    }

    void store(String string, boolean bl) {
        this.store(string, String.valueOf(bl));
    }

    void storeBytes(String string, long l) {
        int n = OS.strlen(l);
        byte[] byArray = new byte[n];
        OS.memmove(byArray, l, (long)n);
        this.store(string.getBytes(), byArray);
    }

    void store(String string, String string2) {
        this.store(string.getBytes(), string2.getBytes());
    }

    void store(byte[] byArray, byte[] byArray2) {
        int n = byArray.length + 1 + byArray2.length + 1;
        if (this.index + n + 1 > this.settingsData.length) {
            byte[] byArray3 = new byte[this.settingsData.length + Math.max(n + 1, 1024)];
            System.arraycopy(this.settingsData, 0, byArray3, 0, this.settingsData.length);
            this.settingsData = byArray3;
        }
        System.arraycopy(byArray, 0, this.settingsData, this.index, byArray.length);
        this.index += byArray.length + 1;
        System.arraycopy(byArray2, 0, this.settingsData, this.index, byArray2.length);
        this.index += byArray2.length + 1;
    }
}

