/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jnati.deploy.artefact;

import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.HashMap;
import net.sf.jnati.SystemTool;
import net.sf.jnati.deploy.artefact.Artefact;
import net.sf.jnati.deploy.resolver.ConfigurationException;
import org.apache.log4j.Logger;
import sea36.util.config.Configuration;

public class ConfigManager {
    private static final Logger LOG = Logger.getLogger(ConfigManager.class);
    private static final String DEFAULT_CONFIG_FILE = "/META-INF/jnati/jnati.default-properties";
    private static final String DEFAULT_INSTANCE_CONFIG_FILE = "/META-INF/jnati/jnati.instance.default-properties";
    private static final String CLASSPATH_CONFIG_FILE = "/META-INF/jnati/jnati.properties";
    private static Configuration defaultConfig;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static synchronized Configuration getDefaultConfig() throws IOException {
        if (defaultConfig == null) {
            LOG.info("Loading global configuration");
            Class<ConfigManager> cl = ConfigManager.class;
            URL u1 = cl.getResource(DEFAULT_CONFIG_FILE);
            if (u1 == null) {
                throw new FileNotFoundException("Default config file missing: /META-INF/jnati/jnati.default-properties");
            }
            String plat = SystemTool.getPlatform();
            String arch = SystemTool.getArchitecture();
            HashMap<String, String> params = new HashMap<String, String>();
            params.put("jnati.os", plat);
            params.put("jnati.arch", arch);
            defaultConfig = new Configuration(params);
            LOG.debug("Loading defaults: " + u1);
            InputStream i1 = u1.openStream();
            try {
                defaultConfig.loadDefaults(i1);
            }
            finally {
                i1.close();
            }
            String filename = defaultConfig.getProperty("jnati.settingsFile");
            if (filename == null) {
                LOG.warn("jnati.settingsFile not defined");
            } else {
                File file = new File(filename);
                if (file.exists()) {
                    LOG.debug("Loading config: " + file);
                    BufferedInputStream i2 = new BufferedInputStream(new FileInputStream(file));
                    try {
                        defaultConfig.loadConfiguration(i2);
                    }
                    finally {
                        ((InputStream)i2).close();
                    }
                }
            }
            URL u3 = cl.getResource(CLASSPATH_CONFIG_FILE);
            if (u3 != null) {
                LOG.debug("Loading configuration: " + u3);
                InputStream is = u3.openStream();
                try {
                    defaultConfig.loadConfiguration(is);
                }
                finally {
                    is.close();
                }
            }
        }
        return defaultConfig;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Configuration getConfig(String id, String version2) throws IOException {
        String artefactConfigFile;
        URL u2;
        Configuration defaultConfig = ConfigManager.getDefaultConfig();
        LOG.info("Loading artefact configuration: " + id + "-" + version2);
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("jnati.artefactId", id);
        params.put("jnati.artefactVersion", version2);
        params.put("jnati.os", SystemTool.getPlatform());
        params.put("jnati.arch", SystemTool.getArchitecture());
        Class<ConfigManager> cl = ConfigManager.class;
        URL u1 = cl.getResource(DEFAULT_INSTANCE_CONFIG_FILE);
        if (u1 == null) {
            throw new FileNotFoundException("Default config file missing: /META-INF/jnati/jnati.instance.default-properties");
        }
        Configuration config = new Configuration(defaultConfig, params);
        InputStream i1 = u1.openStream();
        LOG.debug("Loading instance defaults: " + u1);
        try {
            config.loadDefaults(i1);
        }
        finally {
            i1.close();
        }
        String s1 = "${jnati.artefactId}.settingsFile";
        String fn1 = config.getProperty(s1);
        if (fn1 == null) {
            throw new IOException(s1 + " not defined");
        }
        File f1 = new File(fn1);
        if (f1.exists()) {
            LOG.debug("Loading config: " + f1);
            BufferedInputStream is = new BufferedInputStream(new FileInputStream(f1));
            try {
                config.loadConfiguration(is);
            }
            finally {
                ((InputStream)is).close();
            }
        }
        if ((u2 = cl.getResource(artefactConfigFile = "/META-INF/jnati/" + id + ".properties")) != null) {
            LOG.debug("Loading configuration: " + u2);
            InputStream is = u2.openStream();
            try {
                config.loadConfiguration(is);
            }
            finally {
                is.close();
            }
        }
        return config;
    }

    public static void loadConfiguration(Artefact artefact) throws ConfigurationException {
        try {
            Configuration config = ConfigManager.getConfig(artefact.getId(), artefact.getVersion());
            artefact.setConfiguration(config);
        }
        catch (IOException e) {
            throw new ConfigurationException("Error loading configuration", e);
        }
    }
}

