/*
 * Decompiled with CFR 0.152.
 */
package javax.vecmath;

import java.io.Serializable;
import javax.vecmath.GVector;
import javax.vecmath.Matrix3d;
import javax.vecmath.Matrix3f;
import javax.vecmath.Matrix4d;
import javax.vecmath.Matrix4f;

public class GMatrix
implements Serializable {
    private double[] elementData;
    private int nRow;
    private int nCol;

    public GMatrix(int nRow, int nCol) {
        if (nRow < 0) {
            throw new NegativeArraySizeException(nRow + " < 0");
        }
        if (nCol < 0) {
            throw new NegativeArraySizeException(nCol + " < 0");
        }
        this.nRow = nRow;
        this.nCol = nCol;
        this.elementData = new double[nRow * nCol];
        this.setIdentity();
    }

    public GMatrix(int nRow, int nCol, double[] matrix) {
        if (nRow < 0) {
            throw new NegativeArraySizeException(nRow + " < 0");
        }
        if (nCol < 0) {
            throw new NegativeArraySizeException(nCol + " < 0");
        }
        this.nRow = nRow;
        this.nCol = nCol;
        this.elementData = new double[nRow * nCol];
        this.set(matrix);
    }

    public GMatrix(GMatrix matrix) {
        this.nRow = matrix.nRow;
        this.nCol = matrix.nCol;
        int newSize = this.nRow * this.nCol;
        this.elementData = new double[newSize];
        System.arraycopy(matrix.elementData, 0, this.elementData, 0, newSize);
    }

    public final void mul(GMatrix m1) {
        this.mul(this, m1);
    }

    public final void mul(GMatrix m1, GMatrix m2) {
        if (this.nRow != m1.nRow) {
            throw new ArrayIndexOutOfBoundsException("nRow:" + this.nRow + " != m1.nRow:" + m1.nRow);
        }
        if (this.nCol != m2.nCol) {
            throw new ArrayIndexOutOfBoundsException("nCol:" + this.nCol + " != m2.nCol:" + m2.nCol);
        }
        if (m1.nCol != m2.nRow) {
            throw new ArrayIndexOutOfBoundsException("m1.nCol:" + m1.nCol + " != m2.nRow:" + m2.nRow);
        }
        double[] newData = new double[this.nCol * this.nRow];
        int i = 0;
        while (i < this.nRow) {
            int j = 0;
            while (j < this.nCol) {
                double sum = 0.0;
                int k = 0;
                while (k < m1.nCol) {
                    sum += m1.elementData[i * m1.nCol + k] * m2.elementData[k * m2.nCol + j];
                    ++k;
                }
                newData[i * this.nCol + j] = sum;
                ++j;
            }
            ++i;
        }
        this.elementData = newData;
    }

    public final void mul(GVector v1, GVector v2) {
        if (this.nRow < v1.getSize()) {
            throw new IllegalArgumentException("nRow:" + this.nRow + " < v1.getSize():" + v1.getSize());
        }
        if (this.nCol < v2.getSize()) {
            throw new IllegalArgumentException("nCol:" + this.nCol + " < v2.getSize():" + v2.getSize());
        }
        int i = 0;
        while (i < this.nRow) {
            int j = 0;
            while (j < this.nCol) {
                this.elementData[i * this.nCol + j] = v1.getElement(i) * v2.getElement(j);
                ++j;
            }
            ++i;
        }
    }

    public final void add(GMatrix m1) {
        if (this.nRow != m1.nRow || this.nCol != m1.nCol) {
            throw new IllegalArgumentException("this:(" + this.nRow + "x" + this.nCol + ") != m1:(" + m1.nRow + "x" + m1.nCol + ").");
        }
        int i = 0;
        while (i < this.nRow * this.nCol) {
            int n = i;
            this.elementData[n] = this.elementData[n] + m1.elementData[i];
            ++i;
        }
    }

    public final void add(GMatrix m1, GMatrix m2) {
        if (this.nRow != m1.nRow || this.nCol != m1.nCol) {
            throw new IllegalArgumentException("this:(" + this.nRow + "x" + this.nCol + ") != m1:(" + m1.nRow + "x" + m1.nCol + ").");
        }
        if (this.nRow != m2.nRow || this.nCol != m2.nCol) {
            throw new IllegalArgumentException("this:(" + this.nRow + "x" + this.nCol + ") != m2:(" + m2.nRow + "x" + m2.nCol + ").");
        }
        int i = 0;
        while (i < this.nRow * this.nCol) {
            this.elementData[i] = m1.elementData[i] + m2.elementData[i];
            ++i;
        }
    }

    public final void sub(GMatrix m1) {
        if (this.nRow != m1.nRow || this.nCol != m1.nCol) {
            throw new IllegalArgumentException("this:(" + this.nRow + "x" + this.nCol + ") != m1:(" + m1.nRow + "x" + m1.nCol + ").");
        }
        int i = 0;
        while (i < this.nRow * this.nCol) {
            int n = i;
            this.elementData[n] = this.elementData[n] - m1.elementData[i];
            ++i;
        }
    }

    public final void sub(GMatrix m1, GMatrix m2) {
        if (this.nRow != m1.nRow || this.nCol != m1.nCol) {
            throw new IllegalArgumentException("this:(" + this.nRow + "x" + this.nCol + ") != m1:(" + m1.nRow + "x" + m1.nCol + ").");
        }
        if (this.nRow != m2.nRow || this.nCol != m2.nCol) {
            throw new IllegalArgumentException("this:(" + this.nRow + "x" + this.nCol + ") != m2:(" + m2.nRow + "x" + m2.nCol + ").");
        }
        int i = 0;
        while (i < this.nRow * this.nCol) {
            this.elementData[i] = m1.elementData[i] - m2.elementData[i];
            ++i;
        }
    }

    public final void negate() {
        int i = 0;
        while (i < this.nRow * this.nCol) {
            this.elementData[i] = -this.elementData[i];
            ++i;
        }
    }

    public final void negate(GMatrix m1) {
        this.set(m1);
        this.negate();
    }

    public final void setIdentity() {
        this.setZero();
        int min = this.nRow < this.nCol ? this.nRow : this.nCol;
        int i = 0;
        while (i < min) {
            this.elementData[i * this.nCol + i] = 1.0;
            ++i;
        }
    }

    public final void setZero() {
        int i = 0;
        while (i < this.nRow * this.nCol) {
            this.elementData[i] = 0.0;
            ++i;
        }
    }

    public final void identityMinus() {
        this.negate();
        int min = this.nRow < this.nCol ? this.nRow : this.nCol;
        int i = 0;
        while (i < min) {
            int n = i * this.nCol + i;
            this.elementData[n] = this.elementData[n] + 1.0;
            ++i;
        }
    }

    public final void invert() {
        if (this.nRow != this.nCol) {
            throw new ArrayIndexOutOfBoundsException("not a square matrix");
        }
        int n = this.nRow;
        GMatrix LU = new GMatrix(n, n);
        GVector permutation = new GVector(n);
        GVector column = new GVector(n);
        GVector unit = new GVector(n);
        this.LUD(LU, permutation);
        int j = 0;
        while (j < n) {
            unit.zero();
            unit.setElement(j, 1.0);
            column.LUDBackSolve(LU, unit, permutation);
            this.setColumn(j, column);
            ++j;
        }
    }

    public final void invert(GMatrix m1) {
        this.set(m1);
        this.invert();
    }

    public final void copySubMatrix(int rowSource, int colSource, int numRow, int numCol, int rowDest, int colDest, GMatrix target) {
        if (rowSource < 0 || colSource < 0 || rowDest < 0 || colDest < 0) {
            throw new ArrayIndexOutOfBoundsException("rowSource,colSource,rowDest,colDest < 0.");
        }
        if (this.nRow < numRow + rowSource || this.nCol < numCol + colSource) {
            throw new ArrayIndexOutOfBoundsException("Source GMatrix too small.");
        }
        if (target.nRow < numRow + rowDest || target.nCol < numCol + colDest) {
            throw new ArrayIndexOutOfBoundsException("Target GMatrix too small.");
        }
        int i = 0;
        while (i < numRow) {
            int j = 0;
            while (j < numCol) {
                target.elementData[(i + rowDest) * this.nCol + (j + colDest)] = this.elementData[(i + rowSource) * this.nCol + (j + colSource)];
                ++j;
            }
            ++i;
        }
    }

    public final void setSize(int nRow, int nCol) {
        if (nRow < 0 || nCol < 0) {
            throw new NegativeArraySizeException("nRow or nCol < 0");
        }
        int oldnRow = this.nRow;
        int oldnCol = this.nCol;
        int oldSize = this.nRow * this.nCol;
        this.nRow = nRow;
        this.nCol = nCol;
        int newSize = nRow * nCol;
        double[] oldData = this.elementData;
        if (oldnCol == nCol) {
            if (nRow <= oldnRow) {
                return;
            }
            this.elementData = new double[newSize];
            System.arraycopy(oldData, 0, this.elementData, 0, oldSize);
        } else {
            this.elementData = new double[newSize];
            this.setZero();
            int i = 0;
            while (i < oldnRow) {
                System.arraycopy(oldData, i * oldnCol, this.elementData, i * nCol, oldnCol);
                ++i;
            }
        }
    }

    public final void set(double[] matrix) {
        int size = this.nRow * this.nCol;
        System.arraycopy(matrix, 0, this.elementData, 0, size);
    }

    public final void set(Matrix3f m1) {
        this.elementData[0] = m1.m00;
        this.elementData[1] = m1.m01;
        this.elementData[2] = m1.m02;
        this.elementData[this.nCol] = m1.m10;
        this.elementData[this.nCol + 1] = m1.m11;
        this.elementData[this.nCol + 2] = m1.m12;
        this.elementData[2 * this.nCol] = m1.m20;
        this.elementData[2 * this.nCol + 1] = m1.m21;
        this.elementData[2 * this.nCol + 2] = m1.m22;
    }

    public final void set(Matrix3d m1) {
        this.elementData[0] = m1.m00;
        this.elementData[1] = m1.m01;
        this.elementData[2] = m1.m02;
        this.elementData[this.nCol] = m1.m10;
        this.elementData[this.nCol + 1] = m1.m11;
        this.elementData[this.nCol + 2] = m1.m12;
        this.elementData[2 * this.nCol] = m1.m20;
        this.elementData[2 * this.nCol + 1] = m1.m21;
        this.elementData[2 * this.nCol + 2] = m1.m22;
    }

    public final void set(Matrix4f m1) {
        this.elementData[0] = m1.m00;
        this.elementData[1] = m1.m01;
        this.elementData[2] = m1.m02;
        this.elementData[3] = m1.m03;
        this.elementData[this.nCol] = m1.m10;
        this.elementData[this.nCol + 1] = m1.m11;
        this.elementData[this.nCol + 2] = m1.m12;
        this.elementData[this.nCol + 3] = m1.m13;
        this.elementData[2 * this.nCol] = m1.m20;
        this.elementData[2 * this.nCol + 1] = m1.m21;
        this.elementData[2 * this.nCol + 2] = m1.m22;
        this.elementData[2 * this.nCol + 3] = m1.m23;
        this.elementData[3 * this.nCol] = m1.m30;
        this.elementData[3 * this.nCol + 1] = m1.m31;
        this.elementData[3 * this.nCol + 2] = m1.m32;
        this.elementData[3 * this.nCol + 3] = m1.m33;
    }

    public final void set(Matrix4d m1) {
        this.elementData[0] = m1.m00;
        this.elementData[1] = m1.m01;
        this.elementData[2] = m1.m02;
        this.elementData[3] = m1.m03;
        this.elementData[this.nCol] = m1.m10;
        this.elementData[this.nCol + 1] = m1.m11;
        this.elementData[this.nCol + 2] = m1.m12;
        this.elementData[this.nCol + 3] = m1.m13;
        this.elementData[2 * this.nCol] = m1.m20;
        this.elementData[2 * this.nCol + 1] = m1.m21;
        this.elementData[2 * this.nCol + 2] = m1.m22;
        this.elementData[2 * this.nCol + 3] = m1.m23;
        this.elementData[3 * this.nCol] = m1.m30;
        this.elementData[3 * this.nCol + 1] = m1.m31;
        this.elementData[3 * this.nCol + 2] = m1.m32;
        this.elementData[3 * this.nCol + 3] = m1.m33;
    }

    public final void set(GMatrix m1) {
        if (m1.nRow < this.nRow || m1.nCol < this.nCol) {
            throw new ArrayIndexOutOfBoundsException("m1 smaller than this matrix");
        }
        System.arraycopy(m1.elementData, 0, this.elementData, 0, this.nRow * this.nCol);
    }

    public final int getNumRow() {
        return this.nRow;
    }

    public final int getNumCol() {
        return this.nCol;
    }

    public final double getElement(int row, int column) {
        if (this.nRow <= row) {
            throw new ArrayIndexOutOfBoundsException("row:" + row + " > matrix's nRow:" + this.nRow);
        }
        if (row < 0) {
            throw new ArrayIndexOutOfBoundsException("row:" + row + " < 0");
        }
        if (this.nCol <= column) {
            throw new ArrayIndexOutOfBoundsException("column:" + column + " > matrix's nCol:" + this.nCol);
        }
        if (column < 0) {
            throw new ArrayIndexOutOfBoundsException("column:" + column + " < 0");
        }
        return this.elementData[row * this.nCol + column];
    }

    public final void setElement(int row, int column, double value) {
        if (this.nRow <= row) {
            throw new ArrayIndexOutOfBoundsException("row:" + row + " > matrix's nRow:" + this.nRow);
        }
        if (row < 0) {
            throw new ArrayIndexOutOfBoundsException("row:" + row + " < 0");
        }
        if (this.nCol <= column) {
            throw new ArrayIndexOutOfBoundsException("column:" + column + " > matrix's nCol:" + this.nCol);
        }
        if (column < 0) {
            throw new ArrayIndexOutOfBoundsException("column:" + column + " < 0");
        }
        this.elementData[row * this.nCol + column] = value;
    }

    public final void getRow(int row, double[] array) {
        if (this.nRow <= row) {
            throw new ArrayIndexOutOfBoundsException("row:" + row + " > matrix's nRow:" + this.nRow);
        }
        if (row < 0) {
            throw new ArrayIndexOutOfBoundsException("row:" + row + " < 0");
        }
        if (array.length < this.nCol) {
            throw new ArrayIndexOutOfBoundsException("array length:" + array.length + " smaller than matrix's nCol:" + this.nCol);
        }
        System.arraycopy(this.elementData, row * this.nCol, array, 0, this.nCol);
    }

    public final void getRow(int row, GVector vector) {
        if (this.nRow <= row) {
            throw new ArrayIndexOutOfBoundsException("row:" + row + " > matrix's nRow:" + this.nRow);
        }
        if (row < 0) {
            throw new ArrayIndexOutOfBoundsException("row:" + row + " < 0");
        }
        if (vector.getSize() < this.nCol) {
            throw new ArrayIndexOutOfBoundsException("vector size:" + vector.getSize() + " smaller than matrix's nCol:" + this.nCol);
        }
        int i = 0;
        while (i < this.nCol) {
            vector.setElement(i, this.elementData[row * this.nCol + i]);
            ++i;
        }
    }

    public final void getColumn(int col, double[] array) {
        if (this.nCol <= col) {
            throw new ArrayIndexOutOfBoundsException("col:" + col + " > matrix's nCol:" + this.nCol);
        }
        if (col < 0) {
            throw new ArrayIndexOutOfBoundsException("col:" + col + " < 0");
        }
        if (array.length < this.nRow) {
            throw new ArrayIndexOutOfBoundsException("array.length:" + array.length + " < matrix's nRow=" + this.nRow);
        }
        int i = 0;
        while (i < this.nRow) {
            array[i] = this.elementData[i * this.nCol + col];
            ++i;
        }
    }

    public final void getColumn(int col, GVector vector) {
        if (this.nCol <= col) {
            throw new ArrayIndexOutOfBoundsException("col:" + col + " > matrix's nCol:" + this.nCol);
        }
        if (col < 0) {
            throw new ArrayIndexOutOfBoundsException("col:" + col + " < 0");
        }
        if (vector.getSize() < this.nRow) {
            throw new ArrayIndexOutOfBoundsException("vector size:" + vector.getSize() + " < matrix's nRow:" + this.nRow);
        }
        int i = 0;
        while (i < this.nRow) {
            vector.setElement(i, this.elementData[i * this.nCol + col]);
            ++i;
        }
    }

    public final void get(Matrix3d m1) {
        m1.m00 = this.elementData[0];
        m1.m01 = this.elementData[1];
        m1.m02 = this.elementData[2];
        m1.m10 = this.elementData[this.nCol];
        m1.m11 = this.elementData[this.nCol + 1];
        m1.m12 = this.elementData[this.nCol + 2];
        m1.m20 = this.elementData[2 * this.nCol];
        m1.m21 = this.elementData[2 * this.nCol + 1];
        m1.m22 = this.elementData[2 * this.nCol + 2];
    }

    public final void get(Matrix3f m1) {
        m1.m00 = (float)this.elementData[0];
        m1.m01 = (float)this.elementData[1];
        m1.m02 = (float)this.elementData[2];
        m1.m10 = (float)this.elementData[this.nCol];
        m1.m11 = (float)this.elementData[this.nCol + 1];
        m1.m12 = (float)this.elementData[this.nCol + 2];
        m1.m20 = (float)this.elementData[2 * this.nCol];
        m1.m21 = (float)this.elementData[2 * this.nCol + 1];
        m1.m22 = (float)this.elementData[2 * this.nCol + 2];
    }

    public final void get(Matrix4d m1) {
        m1.m00 = this.elementData[0];
        m1.m01 = this.elementData[1];
        m1.m02 = this.elementData[2];
        m1.m03 = this.elementData[3];
        m1.m10 = this.elementData[this.nCol];
        m1.m11 = this.elementData[this.nCol + 1];
        m1.m12 = this.elementData[this.nCol + 2];
        m1.m13 = this.elementData[this.nCol + 3];
        m1.m20 = this.elementData[2 * this.nCol];
        m1.m21 = this.elementData[2 * this.nCol + 1];
        m1.m22 = this.elementData[2 * this.nCol + 2];
        m1.m23 = this.elementData[2 * this.nCol + 3];
        m1.m30 = this.elementData[3 * this.nCol];
        m1.m31 = this.elementData[3 * this.nCol + 1];
        m1.m32 = this.elementData[3 * this.nCol + 2];
        m1.m33 = this.elementData[3 * this.nCol + 3];
    }

    public final void get(Matrix4f m1) {
        m1.m00 = (float)this.elementData[0];
        m1.m01 = (float)this.elementData[1];
        m1.m02 = (float)this.elementData[2];
        m1.m03 = (float)this.elementData[3];
        m1.m10 = (float)this.elementData[this.nCol];
        m1.m11 = (float)this.elementData[this.nCol + 1];
        m1.m12 = (float)this.elementData[this.nCol + 2];
        m1.m13 = (float)this.elementData[this.nCol + 3];
        m1.m20 = (float)this.elementData[2 * this.nCol];
        m1.m21 = (float)this.elementData[2 * this.nCol + 1];
        m1.m22 = (float)this.elementData[2 * this.nCol + 2];
        m1.m23 = (float)this.elementData[2 * this.nCol + 3];
        m1.m30 = (float)this.elementData[3 * this.nCol];
        m1.m31 = (float)this.elementData[3 * this.nCol + 1];
        m1.m32 = (float)this.elementData[3 * this.nCol + 2];
        m1.m33 = (float)this.elementData[3 * this.nCol + 3];
    }

    public final void get(GMatrix m1) {
        if (m1.nRow < this.nRow || m1.nCol < this.nCol) {
            throw new IllegalArgumentException("m1 matrix is smaller than this matrix.");
        }
        if (m1.nCol == this.nCol) {
            System.arraycopy(this.elementData, 0, m1.elementData, 0, this.nRow * this.nCol);
        } else {
            int i = 0;
            while (i < this.nRow) {
                System.arraycopy(this.elementData, i * this.nCol, m1.elementData, i * m1.nCol, this.nCol);
                ++i;
            }
        }
    }

    public final void setRow(int row, double[] array) {
        if (this.nRow <= row) {
            throw new ArrayIndexOutOfBoundsException("row:" + row + " > matrix's nRow:" + this.nRow);
        }
        if (row < 0) {
            throw new ArrayIndexOutOfBoundsException("row:" + row + " < 0");
        }
        if (array.length < this.nCol) {
            throw new ArrayIndexOutOfBoundsException("array length:" + array.length + " < matrix's nCol=" + this.nCol);
        }
        System.arraycopy(array, 0, this.elementData, row * this.nCol, this.nCol);
    }

    public final void setRow(int row, GVector vector) {
        if (this.nRow <= row) {
            throw new ArrayIndexOutOfBoundsException("row:" + row + " > matrix's nRow:" + this.nRow);
        }
        if (row < 0) {
            throw new ArrayIndexOutOfBoundsException("row:" + row + " < 0");
        }
        int vecSize = vector.getSize();
        if (vecSize < this.nCol) {
            throw new ArrayIndexOutOfBoundsException("vector's size:" + vecSize + " < matrix's nCol=" + this.nCol);
        }
        int i = 0;
        while (i < this.nCol) {
            this.elementData[row * this.nCol + i] = vector.getElement(i);
            ++i;
        }
    }

    public final void setColumn(int col, double[] array) {
        if (this.nCol <= col) {
            throw new ArrayIndexOutOfBoundsException("col:" + col + " > matrix's nCol=" + this.nCol);
        }
        if (col < 0) {
            throw new ArrayIndexOutOfBoundsException("col:" + col + " < 0");
        }
        if (array.length < this.nRow) {
            throw new ArrayIndexOutOfBoundsException("array length:" + array.length + " < matrix's nRow:" + this.nRow);
        }
        int i = 0;
        while (i < this.nRow) {
            this.elementData[i * this.nCol + col] = array[i];
            ++i;
        }
    }

    public final void setColumn(int col, GVector vector) {
        if (this.nCol <= col) {
            throw new ArrayIndexOutOfBoundsException("col:" + col + " > matrix's nCol=" + this.nCol);
        }
        if (col < 0) {
            throw new ArrayIndexOutOfBoundsException("col:" + col + " < 0");
        }
        int vecSize = vector.getSize();
        if (vecSize < this.nRow) {
            throw new ArrayIndexOutOfBoundsException("vector size:" + vecSize + " < matrix's nRow=" + this.nRow);
        }
        int i = 0;
        while (i < this.nRow) {
            this.elementData[i * this.nCol + col] = vector.getElement(i);
            ++i;
        }
    }

    public final void mulTransposeBoth(GMatrix m1, GMatrix m2) {
        this.mul(m2, m1);
        this.transpose();
    }

    public final void mulTransposeRight(GMatrix m1, GMatrix m2) {
        if (m1.nCol != m2.nCol || this.nRow != m1.nRow || this.nCol != m2.nRow) {
            throw new ArrayIndexOutOfBoundsException("matrices mismatch");
        }
        int i = 0;
        while (i < this.nRow) {
            int j = 0;
            while (j < this.nCol) {
                double sum = 0.0;
                int k = 0;
                while (k < m1.nCol) {
                    sum += m1.elementData[i * m1.nCol + k] * m2.elementData[j * m2.nCol + k];
                    ++k;
                }
                this.elementData[i * this.nCol + j] = sum;
                ++j;
            }
            ++i;
        }
    }

    public final void mulTransposeLeft(GMatrix m1, GMatrix m2) {
        this.transpose(m1);
        this.mul(m2);
    }

    public final void transpose() {
        int i = 0;
        while (i < this.nRow) {
            int j = i + 1;
            while (j < this.nCol) {
                double tmp = this.elementData[i * this.nCol + j];
                this.elementData[i * this.nCol + j] = this.elementData[j * this.nCol + i];
                this.elementData[j * this.nCol + i] = tmp;
                ++j;
            }
            ++i;
        }
    }

    public final void transpose(GMatrix m1) {
        this.set(m1);
        this.transpose();
    }

    public String toString() {
        String nl = System.getProperty("line.separator");
        StringBuffer out = new StringBuffer("[");
        out.append(nl);
        int i = 0;
        while (i < this.nRow) {
            out.append("  [");
            int j = 0;
            while (j < this.nCol) {
                if (0 < j) {
                    out.append("\t");
                }
                out.append(this.elementData[i * this.nCol + j]);
                ++j;
            }
            if (i + 1 < this.nRow) {
                out.append("]");
                out.append(nl);
            } else {
                out.append("] ]");
            }
            ++i;
        }
        return out.toString();
    }

    public int hashCode() {
        int hash = 0;
        int i = 0;
        while (i < this.nRow * this.nCol) {
            long bits = Double.doubleToLongBits(this.elementData[i]);
            hash ^= (int)(bits ^ bits >> 32);
            ++i;
        }
        return hash;
    }

    public boolean equals(GMatrix m1) {
        if (m1 == null) {
            return false;
        }
        if (m1.nRow != this.nRow) {
            return false;
        }
        if (m1.nCol != this.nCol) {
            return false;
        }
        int i = 0;
        while (i < this.nRow) {
            int j = 0;
            while (j < this.nCol) {
                if (this.elementData[i * this.nCol + j] != m1.elementData[i * this.nCol + j]) {
                    return false;
                }
                ++j;
            }
            ++i;
        }
        return true;
    }

    public boolean equals(Object o1) {
        return o1 != null && o1 instanceof GMatrix && this.equals((GMatrix)o1);
    }

    public boolean epsilonEquals(GMatrix m1, float epsilon) {
        if (m1.nRow != this.nRow) {
            return false;
        }
        if (m1.nCol != this.nCol) {
            return false;
        }
        int i = 0;
        while (i < this.nRow) {
            int j = 0;
            while (j < this.nCol) {
                if ((double)epsilon < Math.abs(this.elementData[i * this.nCol + j] - m1.elementData[i * this.nCol + j])) {
                    return false;
                }
                ++j;
            }
            ++i;
        }
        return true;
    }

    public boolean epsilonEquals(GMatrix m1, double epsilon) {
        if (m1.nRow != this.nRow) {
            return false;
        }
        if (m1.nCol != this.nCol) {
            return false;
        }
        int i = 0;
        while (i < this.nRow) {
            int j = 0;
            while (j < this.nCol) {
                if (epsilon < Math.abs(this.elementData[i * this.nCol + j] - m1.elementData[i * this.nCol + j])) {
                    return false;
                }
                ++j;
            }
            ++i;
        }
        return true;
    }

    public final double trace() {
        int min = this.nRow < this.nCol ? this.nRow : this.nCol;
        double trace = 0.0;
        int i = 0;
        while (i < min) {
            trace += this.elementData[i * this.nCol + i];
            ++i;
        }
        return trace;
    }

    public final void setScale(double scale) {
        this.setZero();
        int min = this.nRow < this.nCol ? this.nRow : this.nCol;
        int i = 0;
        while (i < min) {
            this.elementData[i * this.nCol + i] = scale;
            ++i;
        }
    }

    private void setDiag(int i, double value) {
        this.elementData[i * this.nCol + i] = value;
    }

    private double getDiag(int i) {
        return this.elementData[i * this.nCol + i];
    }

    private double dpythag(double a, double b) {
        double absb;
        double absa = Math.abs(a);
        if (absa > (absb = Math.abs(b))) {
            if (absa == 0.0) {
                return 0.0;
            }
            double term = absb / absa;
            if (Math.abs(term) <= Double.MIN_VALUE) {
                return absa;
            }
            return absa * Math.sqrt(1.0 + term * term);
        }
        if (absb == 0.0) {
            return 0.0;
        }
        double term = absa / absb;
        if (Math.abs(term) <= Double.MIN_VALUE) {
            return absb;
        }
        return absb * Math.sqrt(1.0 + term * term);
    }

    public final int SVD(GMatrix u, GMatrix w, GMatrix v) {
        double h;
        double f;
        int k;
        double s;
        int j;
        if (u.nRow != this.nRow || u.nCol != this.nRow) {
            throw new ArrayIndexOutOfBoundsException("The U Matrix invalid size");
        }
        if (v.nRow != this.nCol || v.nCol != this.nCol) {
            throw new ArrayIndexOutOfBoundsException("The V Matrix invalid size");
        }
        if (w.nCol != this.nCol || w.nRow != this.nRow) {
            throw new ArrayIndexOutOfBoundsException("The W Matrix invalid size");
        }
        int m = this.nRow;
        int n = this.nCol;
        int imax = m > n ? m : n;
        double[] A = u.elementData;
        double[] V = v.elementData;
        int l = 0;
        int nm = 0;
        double[] rv1 = new double[n];
        this.get(u);
        int i = m;
        while (i < imax) {
            j = 0;
            while (j < imax) {
                A[i * m + j] = 0.0;
                ++j;
            }
            ++i;
        }
        j = n;
        while (j < imax) {
            i = 0;
            while (i < imax) {
                A[i * m + j] = 0.0;
                ++i;
            }
            ++j;
        }
        w.setZero();
        double anorm = 0.0;
        double scale = 0.0;
        double g = 0.0;
        i = 0;
        while (i < n) {
            double a1;
            l = i + 1;
            rv1[i] = scale * g;
            scale = 0.0;
            s = 0.0;
            g = 0.0;
            if (i < m) {
                k = i;
                while (k < m) {
                    scale += Math.abs(A[k * m + i]);
                    ++k;
                }
                if (scale != 0.0) {
                    k = i;
                    while (k < m) {
                        int n2 = k * m + i;
                        A[n2] = A[n2] / scale;
                        s += A[k * m + i] * A[k * m + i];
                        ++k;
                    }
                    f = A[i * m + i];
                    g = f < 0.0 ? Math.sqrt(s) : -Math.sqrt(s);
                    h = f * g - s;
                    A[i * m + i] = f - g;
                    j = l;
                    while (j < n) {
                        s = 0.0;
                        k = i;
                        while (k < m) {
                            s += A[k * m + i] * A[k * m + j];
                            ++k;
                        }
                        f = s / h;
                        k = i;
                        while (k < m) {
                            int n3 = k * m + j;
                            A[n3] = A[n3] + f * A[k * m + i];
                            ++k;
                        }
                        ++j;
                    }
                    k = i;
                    while (k < m) {
                        int n4 = k * m + i;
                        A[n4] = A[n4] * scale;
                        ++k;
                    }
                }
            }
            w.setDiag(i, scale * g);
            scale = 0.0;
            s = 0.0;
            g = 0.0;
            if (i < m && i != n - 1) {
                k = l;
                while (k < n) {
                    scale += Math.abs(A[i * m + k]);
                    ++k;
                }
                if (scale != 0.0) {
                    k = l;
                    while (k < n) {
                        int n5 = i * m + k;
                        A[n5] = A[n5] / scale;
                        s += A[i * m + k] * A[i * m + k];
                        ++k;
                    }
                    f = A[i * m + l];
                    g = f < 0.0 ? Math.sqrt(s) : -Math.sqrt(s);
                    h = f * g - s;
                    A[i * m + l] = f - g;
                    k = l;
                    while (k < n) {
                        rv1[k] = A[i * m + k] / h;
                        ++k;
                    }
                    j = l;
                    while (j < m) {
                        s = 0.0;
                        k = l;
                        while (k < n) {
                            s += A[j * m + k] * A[i * m + k];
                            ++k;
                        }
                        k = l;
                        while (k < n) {
                            int n6 = j * m + k;
                            A[n6] = A[n6] + s * rv1[k];
                            ++k;
                        }
                        ++j;
                    }
                    k = l;
                    while (k < n) {
                        int n7 = i * m + k;
                        A[n7] = A[n7] * scale;
                        ++k;
                    }
                }
            }
            if ((a1 = Math.abs(w.getDiag(i)) + Math.abs(rv1[i])) > anorm) {
                anorm = a1;
            }
            ++i;
        }
        i = n - 1;
        while (i >= 0) {
            if (i < n - 1) {
                if (g != 0.0) {
                    j = l;
                    while (j < n) {
                        V[j * n + i] = A[i * m + j] / A[i * m + l] / g;
                        ++j;
                    }
                    j = l;
                    while (j < n) {
                        s = 0.0;
                        k = l;
                        while (k < n) {
                            s += A[i * m + k] * V[k * n + j];
                            ++k;
                        }
                        k = l;
                        while (k < n) {
                            int n8 = k * n + j;
                            V[n8] = V[n8] + s * V[k * n + i];
                            ++k;
                        }
                        ++j;
                    }
                }
                j = l;
                while (j < n) {
                    V[j * n + i] = 0.0;
                    V[i * n + j] = 0.0;
                    ++j;
                }
            }
            V[i * n + i] = 1.0;
            g = rv1[i];
            l = i--;
        }
        int imin = m < n ? m : n;
        i = imin - 1;
        while (i >= 0) {
            l = i + 1;
            g = w.getDiag(i);
            j = l;
            while (j < n) {
                A[i * m + j] = 0.0;
                ++j;
            }
            if (g != 0.0) {
                g = 1.0 / g;
                j = l;
                while (j < n) {
                    s = 0.0;
                    k = l;
                    while (k < m) {
                        s += A[k * m + i] * A[k * m + j];
                        ++k;
                    }
                    f = s / A[i * m + i] * g;
                    k = i;
                    while (k < m) {
                        int n9 = k * m + j;
                        A[n9] = A[n9] + f * A[k * m + i];
                        ++k;
                    }
                    ++j;
                }
                j = i;
                while (j < m) {
                    int n10 = j * m + i;
                    A[n10] = A[n10] * g;
                    ++j;
                }
            } else {
                j = i;
                while (j < m) {
                    A[j * m + i] = 0.0;
                    ++j;
                }
            }
            int n11 = i * m + i;
            A[n11] = A[n11] + 1.0;
            --i;
        }
        k = n - 1;
        while (k >= 0) {
            int its = 1;
            while (its <= 30) {
                double z;
                double y;
                double c;
                boolean flag = true;
                l = k;
                while (l >= 0) {
                    nm = l - 1;
                    if (Math.abs(rv1[l]) + anorm == anorm) {
                        flag = false;
                        break;
                    }
                    if (Math.abs(w.getDiag(nm)) + anorm == anorm) break;
                    --l;
                }
                if (flag) {
                    c = 0.0;
                    s = 1.0;
                    i = l;
                    while (i <= k) {
                        f = s * rv1[i];
                        rv1[i] = c * rv1[i];
                        if (Math.abs(f) + anorm == anorm) break;
                        g = w.getDiag(i);
                        h = this.dpythag(f, g);
                        w.setDiag(i, h);
                        h = 1.0 / h;
                        c = g * h;
                        s = -f * h;
                        j = 0;
                        while (j < m) {
                            y = A[j * m + nm];
                            z = A[j * m + i];
                            A[j * m + nm] = y * c + z * s;
                            A[j * m + i] = z * c - y * s;
                            ++j;
                        }
                        ++i;
                    }
                }
                z = w.getDiag(k);
                if (l == k) {
                    if (!(z < 0.0)) break;
                    w.setDiag(k, -z);
                    j = 0;
                    while (j < n) {
                        V[j * n + k] = -V[j * n + k];
                        ++j;
                    }
                    break;
                }
                if (its == 30) {
                    return 0;
                }
                double x = w.getDiag(l);
                nm = k - 1;
                y = w.getDiag(nm);
                g = rv1[nm];
                h = rv1[k];
                f = ((y - z) * (y + z) + (g - h) * (g + h)) / (2.0 * h * y);
                g = this.dpythag(f, 1.0);
                f = ((x - z) * (x + z) + h * (y / (f + (f >= 0.0 ? Math.abs(g) : -Math.abs(g))) - h)) / x;
                s = 1.0;
                c = 1.0;
                j = l;
                while (j <= nm) {
                    i = j + 1;
                    g = rv1[i];
                    y = w.getDiag(i);
                    h = s * g;
                    g = c * g;
                    rv1[j] = z = this.dpythag(f, h);
                    c = f / z;
                    s = h / z;
                    f = x * c + g * s;
                    g = g * c - x * s;
                    h = y * s;
                    y *= c;
                    int jj = 0;
                    while (jj < n) {
                        x = V[jj * n + j];
                        z = V[jj * n + i];
                        V[jj * n + j] = x * c + z * s;
                        V[jj * n + i] = z * c - x * s;
                        ++jj;
                    }
                    z = this.dpythag(f, h);
                    w.setDiag(j, z);
                    if (z != 0.0) {
                        z = 1.0 / z;
                        c = f * z;
                        s = h * z;
                    }
                    f = c * g + s * y;
                    x = c * y - s * g;
                    jj = 0;
                    while (jj < m) {
                        y = A[jj * m + j];
                        z = A[jj * m + i];
                        A[jj * m + j] = y * c + z * s;
                        A[jj * m + i] = z * c - y * s;
                        ++jj;
                    }
                    ++j;
                }
                rv1[l] = 0.0;
                rv1[k] = f;
                w.setDiag(k, x);
                ++its;
            }
            --k;
        }
        int rank = 0;
        i = 0;
        while (i < n) {
            if (w.getDiag(i) > 0.0) {
                ++rank;
            }
            ++i;
        }
        return rank;
    }

    private void swapRows(int i, int j) {
        int k = 0;
        while (k < this.nCol) {
            double tmp = this.elementData[i * this.nCol + k];
            this.elementData[i * this.nCol + k] = this.elementData[j * this.nCol + k];
            this.elementData[j * this.nCol + k] = tmp;
            ++k;
        }
    }

    public final int LUD(GMatrix LU, GVector permutation) {
        if (this.nRow != this.nCol) {
            throw new ArrayIndexOutOfBoundsException("not a square matrix");
        }
        int n = this.nRow;
        if (n != LU.nRow) {
            throw new ArrayIndexOutOfBoundsException("this.nRow:" + n + " != LU.nRow:" + LU.nRow);
        }
        if (n != LU.nCol) {
            throw new ArrayIndexOutOfBoundsException("this.nCol:" + n + " != LU.nCol:" + LU.nCol);
        }
        if (permutation.getSize() < n) {
            throw new ArrayIndexOutOfBoundsException("permutation.size:" + permutation.getSize() + " < this.nCol:" + n);
        }
        if (this != LU) {
            LU.set(this);
        }
        int even = 1;
        double[] a = LU.elementData;
        int i = 0;
        while (i < n) {
            permutation.setElement(i, i);
            ++i;
        }
        int j = 0;
        while (j < n) {
            double dum;
            double sum;
            int i2 = 0;
            while (i2 < j) {
                sum = a[i2 * n + j];
                int k = 0;
                while (k < i2) {
                    if (a[i2 * n + k] != 0.0 && a[k * n + j] != 0.0) {
                        sum -= a[i2 * n + k] * a[k * n + j];
                    }
                    ++k;
                }
                a[i2 * n + j] = sum;
                ++i2;
            }
            double big = 0.0;
            int imax = j;
            int i3 = j;
            while (i3 < n) {
                sum = a[i3 * n + j];
                int k = 0;
                while (k < j) {
                    if (a[i3 * n + k] != 0.0 && a[k * n + j] != 0.0) {
                        sum -= a[i3 * n + k] * a[k * n + j];
                    }
                    ++k;
                }
                a[i3 * n + j] = sum;
                dum = Math.abs(sum);
                if (dum >= big) {
                    big = dum;
                    imax = i3;
                }
                ++i3;
            }
            if (j != imax) {
                LU.swapRows(imax, j);
                double tmp = permutation.getElement(imax);
                permutation.setElement(imax, permutation.getElement(j));
                permutation.setElement(j, tmp);
                even = -even;
            }
            if (j != n - 1) {
                dum = 1.0 / a[j * n + j];
                int i4 = j + 1;
                while (i4 < n) {
                    int n2 = i4 * n + j;
                    a[n2] = a[n2] * dum;
                    ++i4;
                }
            }
            ++j;
        }
        return even;
    }
}

