/*
 * Decompiled with CFR 0.152.
 */
package org.openscience.cdk.tools.manipulator;

import org.openscience.cdk.CDKConstants;
import org.openscience.cdk.annotations.TestClass;
import org.openscience.cdk.annotations.TestMethod;
import org.openscience.cdk.interfaces.IAtom;
import org.openscience.cdk.interfaces.IAtomType;
import org.openscience.cdk.interfaces.IPseudoAtom;

@TestClass(value="org.openscience.cdk.tools.manipulator.AtomTypeManipulatorTest")
public class AtomTypeManipulator {
    @TestMethod(value="testConfigure_IAtom_IAtomType")
    public static void configure(IAtom atom, IAtomType atomType) {
        if (atomType == null) {
            throw new IllegalArgumentException("The IAtomType was null.");
        }
        atom.setAtomTypeName(atomType.getAtomTypeName());
        if (!(atom instanceof IPseudoAtom)) {
            atom.setSymbol(atomType.getSymbol());
            atom.setMaxBondOrder(atomType.getMaxBondOrder());
            atom.setBondOrderSum(atomType.getBondOrderSum());
            atom.setCovalentRadius(atomType.getCovalentRadius());
            atom.setValency(atomType.getValency());
            atom.setFormalCharge(atomType.getFormalCharge());
            atom.setHybridization(atomType.getHybridization());
            atom.setFormalNeighbourCount(atomType.getFormalNeighbourCount());
            atom.setFlag(9, atomType.getFlag(9));
            atom.setFlag(8, atomType.getFlag(8));
            Object constant = atomType.getProperty("cdk:Chemical Group");
            if (constant != null) {
                atom.setProperty("cdk:Chemical Group", constant);
            }
            atom.setFlag(5, atomType.getFlag(5));
            Object color = atomType.getProperty("org.openscience.cdk.renderer.color");
            if (color != null) {
                atom.setProperty("org.openscience.cdk.renderer.color", color);
            }
            if (atomType.getAtomicNumber() != CDKConstants.UNSET) {
                atom.setAtomicNumber(atomType.getAtomicNumber());
            }
            if (atomType.getExactMass() != CDKConstants.UNSET) {
                atom.setExactMass(atomType.getExactMass());
            }
        }
    }

    @TestMethod(value="testConfigureUnsetProperties_DontOverwriterSetProperties,testConfigureUnsetProperties")
    public static void configureUnsetProperties(IAtom atom, IAtomType atomType) {
        if (atomType == null) {
            throw new IllegalArgumentException("The IAtomType was null.");
        }
        if (atom.getSymbol() == CDKConstants.UNSET && atomType.getSymbol() != CDKConstants.UNSET) {
            atom.setSymbol(atomType.getSymbol());
        }
        if (atom.getAtomTypeName() == CDKConstants.UNSET && atomType.getAtomTypeName() != CDKConstants.UNSET) {
            atom.setAtomTypeName(atomType.getAtomTypeName());
        }
        if (atom.getMaxBondOrder() == CDKConstants.UNSET && atomType.getMaxBondOrder() != CDKConstants.UNSET) {
            atom.setMaxBondOrder(atomType.getMaxBondOrder());
        }
        if (atom.getBondOrderSum() == CDKConstants.UNSET && atomType.getBondOrderSum() != CDKConstants.UNSET) {
            atom.setBondOrderSum(atomType.getBondOrderSum());
        }
        if (atom.getCovalentRadius() == CDKConstants.UNSET && atomType.getCovalentRadius() != CDKConstants.UNSET) {
            atom.setCovalentRadius(atomType.getCovalentRadius());
        }
        if (atom.getValency() == CDKConstants.UNSET && atomType.getValency() != CDKConstants.UNSET) {
            atom.setValency(atomType.getValency());
        }
        if (atom.getFormalCharge() == CDKConstants.UNSET && atomType.getFormalCharge() != CDKConstants.UNSET) {
            atom.setFormalCharge(atomType.getFormalCharge());
        }
        if (atom.getHybridization() == CDKConstants.UNSET && atomType.getHybridization() != CDKConstants.UNSET) {
            atom.setHybridization(atomType.getHybridization());
        }
        if (atom.getFormalNeighbourCount() == CDKConstants.UNSET && atomType.getFormalNeighbourCount() != CDKConstants.UNSET) {
            atom.setFormalNeighbourCount(atomType.getFormalNeighbourCount());
        }
        if (atom.getAtomicNumber() == CDKConstants.UNSET && atomType.getAtomicNumber() != CDKConstants.UNSET) {
            atom.setAtomicNumber(atomType.getAtomicNumber());
        }
        if (atom.getExactMass() == CDKConstants.UNSET && atomType.getExactMass() != CDKConstants.UNSET) {
            atom.setExactMass(atomType.getExactMass());
        }
    }
}

