/*
 * Decompiled with CFR 0.152.
 */
package org.openscience.cdk.reaction.mechanism;

import java.util.ArrayList;
import java.util.List;
import org.openscience.cdk.DefaultChemObjectBuilder;
import org.openscience.cdk.annotations.TestClass;
import org.openscience.cdk.annotations.TestMethod;
import org.openscience.cdk.atomtype.CDKAtomTypeMatcher;
import org.openscience.cdk.exception.CDKException;
import org.openscience.cdk.interfaces.IAtom;
import org.openscience.cdk.interfaces.IAtomType;
import org.openscience.cdk.interfaces.IBond;
import org.openscience.cdk.interfaces.ILonePair;
import org.openscience.cdk.interfaces.IMapping;
import org.openscience.cdk.interfaces.IMolecule;
import org.openscience.cdk.interfaces.IMoleculeSet;
import org.openscience.cdk.interfaces.IReaction;
import org.openscience.cdk.reaction.IReactionMechanism;
import org.openscience.cdk.tools.manipulator.AtomContainerManipulator;
import org.openscience.cdk.tools.manipulator.BondManipulator;

@TestClass(value="org.openscience.cdk.reaction.mechanism.SharingElectronMechanismTest")
public class SharingElectronMechanism
implements IReactionMechanism {
    @Override
    @TestMethod(value="testInitiate_IMoleculeSet_ArrayList_ArrayList")
    public IReaction initiate(IMoleculeSet moleculeSet, ArrayList<IAtom> atomList, ArrayList<IBond> bondList) throws CDKException {
        IMolecule reactantCloned;
        CDKAtomTypeMatcher atMatcher = CDKAtomTypeMatcher.getInstance(moleculeSet.getBuilder());
        if (moleculeSet.getMoleculeCount() != 1) {
            throw new CDKException("SharingElectronMechanism only expects one IMolecule");
        }
        if (atomList.size() != 2) {
            throw new CDKException("SharingElectronMechanism expects two atoms in the ArrayList");
        }
        if (bondList.size() != 1) {
            throw new CDKException("SharingElectronMechanism only expect one bond in the ArrayList");
        }
        IMolecule molecule = moleculeSet.getMolecule(0);
        try {
            reactantCloned = (IMolecule)molecule.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new CDKException("Could not clone IMolecule!", e);
        }
        IAtom atom1 = atomList.get(0);
        IAtom atom1C = reactantCloned.getAtom(molecule.getAtomNumber(atom1));
        IAtom atom2 = atomList.get(1);
        IAtom atom2C = reactantCloned.getAtom(molecule.getAtomNumber(atom2));
        IBond bond1 = bondList.get(0);
        int posBond1 = molecule.getBondNumber(bond1);
        BondManipulator.increaseBondOrder(reactantCloned.getBond(posBond1));
        List<ILonePair> lonePair = reactantCloned.getConnectedLonePairsList(atom1C);
        reactantCloned.removeLonePair(lonePair.get(lonePair.size() - 1));
        int charge = atom1C.getFormalCharge();
        atom1C.setFormalCharge(charge + 1);
        charge = atom2C.getFormalCharge();
        atom2C.setFormalCharge(charge - 1);
        atom1C.setHybridization(null);
        AtomContainerManipulator.percieveAtomTypesAndConfigureAtoms(reactantCloned);
        IAtomType type = atMatcher.findMatchingAtomType(reactantCloned, atom1C);
        if (type == null) {
            return null;
        }
        atom2C.setHybridization(null);
        AtomContainerManipulator.percieveAtomTypesAndConfigureAtoms(reactantCloned);
        type = atMatcher.findMatchingAtomType(reactantCloned, atom2C);
        if (type == null) {
            return null;
        }
        IReaction reaction = DefaultChemObjectBuilder.getInstance().newInstance(IReaction.class, new Object[0]);
        reaction.addReactant(molecule);
        for (IAtom atom : molecule.atoms()) {
            IMapping mapping = DefaultChemObjectBuilder.getInstance().newInstance(IMapping.class, atom, reactantCloned.getAtom(molecule.getAtomNumber(atom)));
            reaction.addMapping(mapping);
        }
        reaction.addProduct(reactantCloned);
        return reaction;
    }
}

