/*
 * Decompiled with CFR 0.152.
 */
package org.openscience.cdk.io.program;

import java.io.BufferedWriter;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.StringWriter;
import java.io.Writer;
import java.util.ArrayList;
import javax.vecmath.Point3d;
import org.openscience.cdk.annotations.TestClass;
import org.openscience.cdk.annotations.TestMethod;
import org.openscience.cdk.exception.CDKException;
import org.openscience.cdk.interfaces.IAtom;
import org.openscience.cdk.interfaces.IChemObject;
import org.openscience.cdk.interfaces.IMolecule;
import org.openscience.cdk.io.DefaultChemObjectWriter;
import org.openscience.cdk.io.formats.GaussianInputFormat;
import org.openscience.cdk.io.formats.IResourceFormat;
import org.openscience.cdk.io.setting.BooleanIOSetting;
import org.openscience.cdk.io.setting.IOSetting;
import org.openscience.cdk.io.setting.IntegerIOSetting;
import org.openscience.cdk.io.setting.OptionIOSetting;
import org.openscience.cdk.io.setting.StringIOSetting;

@TestClass(value="org.openscience.cdk.io.program.GaussianInputWriterTest")
public class GaussianInputWriter
extends DefaultChemObjectWriter {
    static BufferedWriter writer;
    IOSetting method;
    IOSetting basis;
    IOSetting comment;
    IOSetting command;
    IOSetting memory;
    BooleanIOSetting shell;
    IntegerIOSetting proccount;
    BooleanIOSetting usecheckpoint;

    public GaussianInputWriter(Writer out) {
        try {
            writer = out instanceof BufferedWriter ? (BufferedWriter)out : new BufferedWriter(out);
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.initIOSettings();
    }

    public GaussianInputWriter(OutputStream output) {
        this(new OutputStreamWriter(output));
    }

    public GaussianInputWriter() {
        this(new StringWriter());
    }

    @Override
    @TestMethod(value="testGetFormat")
    public IResourceFormat getFormat() {
        return GaussianInputFormat.getInstance();
    }

    @Override
    public void setWriter(Writer out) throws CDKException {
        writer = out instanceof BufferedWriter ? (BufferedWriter)out : new BufferedWriter(out);
    }

    @Override
    public void setWriter(OutputStream output) throws CDKException {
        this.setWriter(new OutputStreamWriter(output));
    }

    @Override
    @TestMethod(value="testClose")
    public void close() throws IOException {
        writer.close();
    }

    @TestMethod(value="testAccepts")
    public boolean accepts(Class classObject) {
        return IMolecule.class.isInstance(classObject);
    }

    @Override
    @TestMethod(value="testWrite")
    public void write(IChemObject object) throws CDKException {
        if (object instanceof IMolecule) {
            try {
                this.writeMolecule((IMolecule)object);
            }
            catch (Exception ex) {
                throw new CDKException("Error while writing Gaussian input file: " + ex.getMessage(), ex);
            }
        } else {
            throw new CDKException("GaussianInputWriter only supports output of Molecule classes.");
        }
    }

    public void writeMolecule(IMolecule mol) throws IOException {
        this.customizeJob();
        if (this.proccount.getSettingValue() > 1) {
            writer.write("%nprocl=" + this.proccount.getSettingValue());
            writer.newLine();
        }
        if (!this.memory.getSetting().equals("unset")) {
            writer.write("%Mem=" + this.memory.getSetting());
            writer.newLine();
        }
        if (this.usecheckpoint.isSet()) {
            if (mol.getID() != null && mol.getID().length() > 0) {
                writer.write("%chk=" + mol.getID() + ".chk");
            } else {
                writer.write("%chk=" + System.currentTimeMillis() + ".chk");
            }
            writer.newLine();
        }
        writer.write("# " + this.method.getSetting() + "/" + this.basis.getSetting() + " ");
        String commandString = this.command.getSetting();
        if (!commandString.equals("energy calculation")) {
            if (commandString.equals("geometry optimization")) {
                writer.write("opt");
            } else if (commandString.equals("IR frequency calculation")) {
                writer.write("freq");
            } else if (commandString.equals("IR frequency calculation (with Raman)")) {
                writer.write("freq=noraman");
            } else {
                writer.write(commandString);
            }
        }
        writer.newLine();
        writer.newLine();
        writer.write(this.comment.getSetting());
        writer.newLine();
        writer.newLine();
        writer.write("0 ");
        if (this.shell.isSet()) {
            writer.write("0");
        } else {
            writer.write("1");
        }
        writer.newLine();
        for (IAtom a : mol.atoms()) {
            String st = a.getSymbol();
            st = st + " 0 ";
            Point3d p3 = a.getPoint3d();
            if (p3 != null) {
                st = st + new Double(p3.x).toString() + " " + new Double(p3.y).toString() + " " + new Double(p3.z).toString();
            }
            writer.write(st, 0, st.length());
            writer.newLine();
        }
        writer.newLine();
    }

    private void initIOSettings() {
        ArrayList<String> basisOptions = new ArrayList<String>();
        basisOptions.add("6-31g");
        basisOptions.add("6-31g*");
        basisOptions.add("6-31g(d)");
        basisOptions.add("6-311g");
        basisOptions.add("6-311+g**");
        this.basis = new OptionIOSetting("Basis", 1, "Which basis set do you want to use?", basisOptions, "6-31g");
        ArrayList<String> methodOptions = new ArrayList<String>();
        methodOptions.add("rb3lyp");
        methodOptions.add("b3lyp");
        methodOptions.add("rhf");
        this.method = new OptionIOSetting("Method", 1, "Which method do you want to use?", methodOptions, "b3lyp");
        ArrayList<String> commandOptions = new ArrayList<String>();
        commandOptions.add("energy calculation");
        commandOptions.add("geometry optimization");
        commandOptions.add("IR frequency calculation");
        commandOptions.add("IR frequency calculation (with Raman)");
        this.command = new OptionIOSetting("Command", 0, "What kind of job do you want to perform?", commandOptions, "energy calculation");
        this.comment = new StringIOSetting("Comment", 2, "What comment should be put in the file?", "Created with CDK (http://cdk.sf.net/)");
        this.memory = new StringIOSetting("Memory", 2, "How much memory do you want to use?", "unset");
        this.shell = new BooleanIOSetting("OpenShell", 1, "Should the calculation be open shell?", "false");
        this.proccount = new IntegerIOSetting("ProcessorCount", 2, "How many processors should be used by Gaussian?", "1");
        this.usecheckpoint = new BooleanIOSetting("UseCheckPointFile", 2, "Should a check point file be saved?", "false");
    }

    private void customizeJob() {
        this.fireIOSettingQuestion(this.basis);
        this.fireIOSettingQuestion(this.method);
        this.fireIOSettingQuestion(this.command);
        this.fireIOSettingQuestion(this.comment);
        this.fireIOSettingQuestion(this.shell);
        this.fireIOSettingQuestion(this.proccount);
        this.fireIOSettingQuestion(this.memory);
        this.fireIOSettingQuestion(this.usecheckpoint);
    }

    @Override
    public IOSetting[] getIOSettings() {
        IOSetting[] settings = new IOSetting[]{this.basis, this.method, this.command, this.comment, this.shell, this.proccount, this.usecheckpoint, this.memory};
        return settings;
    }
}

