/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jniinchi;

import net.sf.jniinchi.INCHI_BOND_STEREO;
import net.sf.jniinchi.INCHI_BOND_TYPE;
import net.sf.jniinchi.JniInchiAtom;

public class JniInchiBond {
    private JniInchiAtom atomOrigin;
    private JniInchiAtom atomTarget;
    private INCHI_BOND_TYPE type = INCHI_BOND_TYPE.NONE;
    private INCHI_BOND_STEREO stereo = INCHI_BOND_STEREO.NONE;

    public JniInchiBond(JniInchiAtom atO, JniInchiAtom atT, INCHI_BOND_TYPE type, INCHI_BOND_STEREO stereo) {
        this.atomOrigin = atO;
        this.atomTarget = atT;
        this.type = type;
        this.stereo = stereo;
    }

    JniInchiBond(JniInchiAtom atO, JniInchiAtom atT, int type, int stereo) {
        this(atO, atT, INCHI_BOND_TYPE.getValue(type), INCHI_BOND_STEREO.getValue(stereo));
    }

    public JniInchiBond(JniInchiAtom atO, JniInchiAtom atT, INCHI_BOND_TYPE type) {
        this(atO, atT, type, INCHI_BOND_STEREO.NONE);
    }

    public void setStereoDefinition(INCHI_BOND_STEREO stereo) {
        this.stereo = stereo;
    }

    public JniInchiAtom getOriginAtom() {
        return this.atomOrigin;
    }

    public JniInchiAtom getTargetAtom() {
        return this.atomTarget;
    }

    public INCHI_BOND_TYPE getBondType() {
        return this.type;
    }

    public INCHI_BOND_STEREO getBondStereo() {
        return this.stereo;
    }

    public String getDebugString() {
        return "InChI Bond: " + this.atomOrigin.getElementType() + "-" + this.atomTarget.getElementType() + " // Type: " + this.type + " // Stereo: " + this.stereo;
    }

    public void debug() {
        System.out.println(this.getDebugString());
    }

    int getInchiBondType() {
        return this.type.getIndx();
    }

    int getInchiBondStereo() {
        return this.stereo.getIndx();
    }
}

