/*
 * Decompiled with CFR 0.152.
 */
package org.openscience.cdk.renderer.selection;

import java.awt.Color;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import javax.vecmath.Point2d;
import org.openscience.cdk.interfaces.IAtom;
import org.openscience.cdk.interfaces.IAtomContainer;
import org.openscience.cdk.interfaces.IBond;
import org.openscience.cdk.interfaces.IChemModel;
import org.openscience.cdk.interfaces.IChemObject;
import org.openscience.cdk.renderer.elements.IRenderingElement;
import org.openscience.cdk.renderer.selection.IncrementalSelection;
import org.openscience.cdk.tools.manipulator.ChemModelManipulator;

public abstract class ShapeSelection
implements IncrementalSelection {
    public final List<IAtom> atoms = new ArrayList<IAtom>();
    public final List<IBond> bonds = new ArrayList<IBond>();
    protected boolean finished = false;

    public abstract boolean contains(Point2d var1);

    public abstract void addPoint(Point2d var1);

    public abstract boolean isEmpty();

    public abstract void reset();

    @Override
    public abstract IRenderingElement generate(Color var1);

    @Override
    public boolean isFinished() {
        return this.finished;
    }

    @Override
    public boolean contains(IChemObject obj) {
        if (obj instanceof IAtom) {
            for (IAtom iAtom : this.atoms) {
                if (iAtom != obj) continue;
                return true;
            }
        }
        if (obj instanceof IBond) {
            for (IBond iBond : this.bonds) {
                if (iBond != obj) continue;
                return true;
            }
        }
        return false;
    }

    public void clear() {
        this.atoms.clear();
        this.bonds.clear();
        this.finished = false;
    }

    @Override
    public boolean isFilled() {
        return !this.atoms.isEmpty() || !this.bonds.isEmpty();
    }

    @Override
    public IAtomContainer getConnectedAtomContainer() {
        if (this.atoms.size() == 0) {
            return null;
        }
        IAtomContainer ac = (IAtomContainer)this.atoms.get(0).getBuilder().newInstance(IAtomContainer.class, new Object[0]);
        for (IAtom atom : this.atoms) {
            ac.addAtom(atom);
        }
        for (IBond bond : this.bonds) {
            boolean addBond = true;
            for (IAtom atom : bond.atoms()) {
                if (ac.contains(atom)) continue;
                addBond = false;
            }
            if (!addBond) continue;
            ac.addBond(bond);
        }
        return ac;
    }

    private void select(IAtomContainer atomContainer) {
        for (IAtom atom : atomContainer.atoms()) {
            if (!this.contains(atom.getPoint2d()) || this.atoms.contains(atom)) continue;
            this.atoms.add(atom);
        }
        for (IBond bond : atomContainer.bonds()) {
            if (!this.contains(bond.get2DCenter()) || this.bonds.contains(bond)) continue;
            this.bonds.add(bond);
        }
    }

    @Override
    public void select(IChemModel chemModel) {
        this.clear();
        for (IAtomContainer atomContainer : ChemModelManipulator.getAllAtomContainers((IChemModel)chemModel)) {
            this.select(atomContainer);
        }
    }

    @Override
    public <E extends IChemObject> Collection<E> elements(Class<E> clazz) {
        HashSet<Object> set = new HashSet<Object>();
        if (clazz.isAssignableFrom(IChemObject.class)) {
            set.addAll(this.atoms);
            set.addAll(this.bonds);
            return set;
        }
        if (clazz.isAssignableFrom(IAtom.class)) {
            set.addAll(this.atoms);
            return set;
        }
        if (clazz.isAssignableFrom(IBond.class)) {
            set.addAll(this.bonds);
            return set;
        }
        return Collections.emptySet();
    }
}

