% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/BlockchainRpcs.R
\name{preciousblock}
\alias{preciousblock}
\title{RPC-JSON API: preciousblock}
\usage{
preciousblock(con, blockhash)
}
\arguments{
\item{con}{object of class \code{CONRPC}.}

\item{blockhash}{\code{character}, the hash of the block to mark as precious.}
}
\value{
A S4-object of class \code{ANSRPC}.
}
\description{
Treats a block as if it were received before others with the same work.
A can override the effect of an earlier one. The effects of preciousblock
are not retained across restarts.
}
\references{
\url{https://bitcoin.org/en/developer-reference#preciousblock},
\url{https://bitcoin.org/en/developer-reference#remote-procedure-calls-rpcs}
}
\seealso{
Other Blockchain RPCs: \code{\link{decodescript}},
  \code{\link{getbestblockhash}},
  \code{\link{getblockchaininfo}},
  \code{\link{getblockcount}}, \code{\link{getblockhash}},
  \code{\link{getblockheader}}, \code{\link{getblock}},
  \code{\link{getchaintips}},
  \code{\link{getchaintxstats}},
  \code{\link{getdifficulty}},
  \code{\link{getmempoolancestors}},
  \code{\link{getmempooldescendants}},
  \code{\link{getmempoolentry}},
  \code{\link{getmempoolinfo}},
  \code{\link{getrawmempool}}, \code{\link{gettxoutproof}},
  \code{\link{gettxoutsetinfo}}, \code{\link{gettxout}},
  \code{\link{pruneblockchain}}, \code{\link{verifychain}},
  \code{\link{verifytxoutproof}}
}
\author{
Bernhard Pfaff
}
\concept{Blockchain RPCs}
