% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/project.R
\name{projects}
\alias{projects}
\alias{lio_project}
\alias{lio_project_dependencies}
\alias{lio_project_dependents}
\alias{lio_project_dependent_repos}
\alias{lio_project_contribs}
\alias{lio_project_sourcerank}
\alias{lio_project_search}
\title{Projects}
\usage{
lio_project(platform, name, key = NULL, ...)

lio_project_dependencies(platform, name, version = "latest", key = NULL, ...)

lio_project_dependents(
  platform,
  name,
  page = 1,
  per_page = 30,
  key = NULL,
  ...
)

lio_project_dependent_repos(
  platform,
  name,
  page = 1,
  per_page = 30,
  key = NULL,
  ...
)

lio_project_contribs(platform, name, page = 1, per_page = 30, key = NULL, ...)

lio_project_sourcerank(platform, name, key = NULL, ...)

lio_project_search(
  q = NULL,
  sort = NULL,
  languages = NULL,
  licenses = NULL,
  keywords = NULL,
  platforms = NULL,
  page = 1,
  per_page = 30,
  key = NULL,
  ...
)
}
\arguments{
\item{platform}{(character) a platform. required}

\item{name}{(character) a project name. required}

\item{key}{your Libraries.io API key. See \code{Auth} section in \pkg{rbraries}
manual file. optional}

\item{...}{curl options passed on to \code{\link[crul]{HttpClient}}}

\item{version}{(character) a version string. optional}

\item{page}{(integer) page to return. Default: 1}

\item{per_page}{(integer) number of records to return per page.
Maximum: 100. Default: 30}

\item{q}{(character) a query string. optional}

\item{sort}{(character) sort by one of rank, stars, dependents_count,
dependent_repos_count, latest_release_published_at, contributions_count,
or created_at. default: no sorting. optional}

\item{languages}{(character) a language name. optional}

\item{licenses}{(character) a license name. optional}

\item{keywords}{(character) a keyword. optional}

\item{platforms}{(character) a platform name. optional}
}
\description{
Projects
}
\examples{
\dontrun{
# project summary
lio_project('npm', 'grunt')

# dependencies
lio_project_dependencies('npm', 'grunt')
lio_project_dependencies('npm', 'grunt', '1.0.1')

# dependent repositories
lio_project_dependent_repos('npm', 'turf')

# project contributors
lio_project_contribs('npm', 'turf')

# source rank
lio_project_sourcerank('npm', 'turf')

# search
lio_project_search(q = 'grunt', per_page = 3)
}
}
