% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/analyse.R
\name{extract_imputed_dfs}
\alias{extract_imputed_dfs}
\title{Extract imputed datasets}
\usage{
extract_imputed_dfs(
  imputations,
  index = seq_along(imputations$imputations),
  delta = NULL,
  idmap = FALSE
)
}
\arguments{
\item{imputations}{An \code{imputations} object as created by \code{\link[=impute]{impute()}}.}

\item{index}{The indexes of the imputed datasets to return. By default,
all datasets within the \code{imputations} object will be returned.}

\item{delta}{A \code{data.frame} containing the delta transformation to be
applied to the imputed dataset. See \code{\link[=analyse]{analyse()}} for details on the
format and specification of this \code{data.frame}.}

\item{idmap}{Logical. The subject IDs in the imputed \code{data.frame}'s are
replaced with new IDs to ensure they are unique. Setting this argument to
\code{TRUE} attaches an attribute, called \code{idmap}, to the returned \code{data.frame}'s
that will provide a map from the new subject IDs to the old subject IDs.}
}
\value{
A list of data.frames equal in length to the \code{index} argument.
}
\description{
Extracts the imputed datasets contained within an \code{imputations} object generated
by \code{\link[=impute]{impute()}}.
}
\examples{
\dontrun{
extract_imputed_dfs(imputeObj)
extract_imputed_dfs(imputeObj, c(1:3))
}
}
\seealso{
\code{\link[=delta_template]{delta_template()}} for creating delta data.frames.

\code{\link[=analyse]{analyse()}}.
}
