% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/delta.R
\name{delta_template}
\alias{delta_template}
\title{Create a delta \code{data.frame} template}
\usage{
delta_template(imputations, delta = NULL, dlag = NULL, missing_only = TRUE)
}
\arguments{
\item{imputations}{an \code{imputation} object as created by \code{\link[=impute]{impute()}}.}

\item{delta}{\code{NULL} or a numeric vector. Determines the baseline amount of delta
to be applied to each visit. See details. If a numeric vector it must have
the same length as the number of unique visits in the original dataset.}

\item{dlag}{\code{NULL} or a numeric vector. Determines the scaling to be applied
to \code{delta} based upon which visit the ICE occurred on. See details. If a
numeric vector it must have the same length as the number of unique visits in
the original dataset.}

\item{missing_only}{Logical, if \code{TRUE} then non-missing post-ICE data will have a delta value
of 0 assigned. Note that the calculation (as described in the details section) is performed
first and then overwritten with 0's at the end (i.e. the delta values for missing
post-ICE visits will stay the same regardless of this option).}
}
\description{
Creates a \code{data.frame} in the format required by \code{\link[=analyse]{analyse()}} for the use
of applying a delta adjustment.
}
\details{
To apply a delta adjustment the \code{\link[=analyse]{analyse()}} function expects
a delta \code{data.frame} with 3 variables: \code{vars$subjid}, \code{vars$visit} and \code{delta}
(where \code{vars} is the object supplied in the original call to \code{\link[=draws]{draws()}}
as created by the \code{\link[=set_vars]{set_vars()}} function).

This function will return a \code{data.frame} with the aforementioned variables with one
row per subject per visit. If the \code{delta} argument to this function is \code{NULL}
then the \code{delta} column in the returned \code{data.frame} will be 0 for all observations.
If the \code{delta} argument is not \code{NULL} then \code{delta} will be calculated separately
for each subject as the accumulative sum of \code{delta} multiplied by the scaling
coefficient \code{dlag} based upon how many visits after the subject's intercurrent
event (ICE) the visit in question is.
This is best illustrated with an example:

Let \code{delta = c(5,6,7,8)} and \code{dlag=c(1,2,3,4)} (i.e. assuming there are 4 visits)
and lets say that the subject had an ICE on visit 2. The calculation would then be
as follows:\preformatted{v1  v2  v3  v4
--------------
 5   6   7   8  # delta assigned to each visit
 0   1   2   3  # lagged scaling starting from the first visit after the subjects ICE
--------------
 0   6  14  24  # delta * lagged scaling
--------------
 0   6  20  44  # accumulative sum of delta to be applied to each visit
}

That is to say the subject would have a delta offset of 0 applied for visit-1, 6
for visit-2, 20 for visit-3 and 44 for visit-4. As a comparison, lets say that the
subject instead had their ICE on visit 3, the calculation would then be as follows:\preformatted{v1  v2  v3  v4
--------------
 5   6   7   8  # delta assigned to each visit
 0   0   1   2  # lagged scaling starting from the first visit after the subjects ICE
--------------
 0   0   7  16  # delta * lagged scaling
--------------
 0   0   7  23  # accumulative sum of delta to be applied to each visit
}

In terms of practical usage, lets say that you wanted a delta of 5 to be used for all post ICE visits
regardless of their proximity to the ICE visit. This can be achieved by setting
\code{delta = c(5,5,5,5)} and \code{dlag = c(1,0,0,0)}. For example lets say a subject had their
ICE on visit-1, then the calculation would be as follows:\preformatted{v1  v2  v3  v4
--------------
 5   5   5   5  # delta assigned to each visit
 1   0   0   0  # lagged scaling starting from the first visit after the subjects ICE
--------------
 5   0   0  0  # delta * lagged scaling
--------------
 5   5   5  5  # accumulative sum of delta to be applied to each visit
}

Another way of using these arguments
is to set \code{delta} to be the difference in time between visits and \code{dlag} to be the
amount of delta per unit of time. For example lets say that we have a visit on weeks
1, 5, 6 & 9 and that we want a delta of 3 to be applied for each week after an ICE. This
can be achieved by setting \code{delta = c(0,4,1,3)} (the difference in weeks between each visit)
and \code{dlag = c(3, 3, 3, 3)}. For example lets say we have a subject who had their ICE on week-5
(i.e. visit-2) then the calculation would be:\preformatted{v1  v2  v3  v4
--------------
 0   4   1   3  # delta assigned to each visit
 0   0   3   3  # lagged scaling starting from the first visit after the subjects ICE
--------------
 0   0   3   9  # delta * lagged scaling
--------------
 0   0   3  12  # accumulative sum of delta to be applied to each visit
}

i.e. on week-6 (1 week after the ICE) they have a delta of 3 and on week-9 (4 weeks after the ICE)
they have a delta of 12.

Please note that this function also returns several utility variables so that
the user can create their own custom logic for defining what \code{delta}
should be set to. These additional variables include:
\itemize{
\item \code{is_mar} - If the observation was missing would it be regarded as MAR? This variable
is set to \code{FALSE} for observations that occurred after a non-MAR ICE, otherwise it is set to \code{TRUE}.
\item \code{is_missing} - Is the outcome variable for this observation missing.
\item \code{is_post_ice} - Does the observation occur after the patient's ICE as defined by the
\code{data_ice} dataset supplied to \code{\link[=draws]{draws()}}.
\item \code{strategy} - What imputation strategy was assigned to for this subject.
}

The design and implementation of this function is largely based upon the same functionality
as implemented in the so called "five marcos" by James Roger. See Roger (2021).
}
\examples{
\dontrun{
delta_template(imputeObj)
delta_template(imputeObj, delta = c(5,6,7,8), dlag = c(1,2,3,4))
}
}
\references{
Roger, James. Reference-based mi via multivariate normal rm (the “five macros” and miwithd), 2021. URL
https://www.lshtm.ac.uk/research/centres-projects-groups/missing-data#dia-missing-data.
}
\seealso{
\code{\link[=analyse]{analyse()}}
}
