% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/validate_datalong.R
\name{validate_datalong}
\alias{validate_datalong}
\alias{validate_datalong_varExists}
\alias{validate_datalong_types}
\alias{validate_datalong_notMissing}
\alias{validate_datalong_complete}
\alias{validate_datalong_unifromStrata}
\alias{validate_dataice}
\title{Validate a longdata object}
\usage{
validate_datalong(data, vars)

validate_datalong_varExists(data, vars)

validate_datalong_types(data, vars)

validate_datalong_notMissing(data, vars)

validate_datalong_complete(data, vars)

validate_datalong_unifromStrata(data, vars)

validate_dataice(data, data_ice, vars, update = FALSE)
}
\arguments{
\item{data}{a \code{data.frame} containing the longitudinal outcome data + covariates
for multiple subjects}

\item{vars}{a \code{vars} object as created by \code{\link[=set_vars]{set_vars()}}}

\item{data_ice}{a \code{data.frame} containing the subjects ICE data. See \code{\link[=draws]{draws()}} for details.}

\item{update}{logical, indicates if the ICE data is being set for the first time or if an update
is being applied}
}
\description{
Validate a longdata object
}
\details{
These functions are used to validate various different parts of the longdata object
to be used in \code{\link[=draws]{draws()}}, \code{\link[=impute]{impute()}}, \code{\link[=analyse]{analyse()}} and \code{\link[=pool]{pool()}}. In particular:
\itemize{
\item validate_datalong_varExists - Checks that each variable listed in \code{vars} actually exists
in the \code{data}
\item validate_datalong_types - Checks that the types of each key variable is as expected
i.e. that visit is a factor variable
\item validate_datalong_notMissing - Checks that none of the key variables (except the outcome variable)
contain any missing values
\item validate_datalong_complete - Checks that \code{data} is complete i.e. there is 1 row for each subject *
visit combination. e.g. that \code{nrow(data) == length(unique(subjects)) * length(unique(visits))}
\item validate_datalong_unifromStrata - Checks to make sure that any variables listed as stratification
variables do not vary over time. e.g. that subjects don't switch between stratification groups.
}
}
