% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/uniprot_coordinates.R
\name{rba_uniprot_coordinates_sequence}
\alias{rba_uniprot_coordinates_sequence}
\title{Get Genome coordinate by Protein Sequence position}
\usage{
rba_uniprot_coordinates_sequence(
  accession,
  p_position = NULL,
  p_start = NULL,
  p_end = NULL,
  ...
)
}
\arguments{
\item{accession}{\href{https://www.uniprot.org/help/accession_numbers}{
UniProtKB primary or secondary accession}.}

\item{p_position}{(numeric) Protein sequence position}

\item{p_start}{(numeric) Protein sequence position start}

\item{p_end}{(numeric) Protein sequence position end}

\item{...}{rbioapi option(s). See \code{\link{rba_options}}'s
arguments manual for more information on available options.}
}
\value{
Genome coordinates of your supplied proteins.
}
\description{
Using this function you can retrieve genome coordinates of a given UniProt
  protein by providing protein position or position range. You can either
  supply 'p_position' alone or supply 'p_start' and 'p_end' together.
}
\details{
For more information about how UniProt imports and calculates genomic
  coordinates data, see:
  \cr McGarvey, P. B., Nightingale, A., Luo, J., Huang, H., Martin, M. J.,
  Wu, C., & UniProt Consortium (2019). UniProt genomic mapping for
  deciphering functional effects of missense variants. Human mutation,
  40(6), 694–705. https://doi.org/10.1002/humu.23738
}
\section{Corresponding API Resources}{

 "GET https://ebi.ac.uk/proteins/api/coordinates/location
 /\{accession\}:\{pPosition\}"
 \cr "GET https://ebi.ac.uk/proteins/api/coordinates/location
 /\{accession\}:\{pStart\}-\{pEnd\}"
}

\examples{
\donttest{
rba_uniprot_coordinates_sequence(accession = "P25942", p_position = 1)
}
\donttest{
rba_uniprot_coordinates_sequence(accession = "P25942",
    p_start = 1, p_end = 277)
}

}
\references{
\itemize{
  \item The UniProt Consortium, UniProt: the universal protein
  knowledgebase in 2021, Nucleic Acids Research, Volume 49, Issue D1,
  8 January 2021, Pages D480–D489, https://doi.org/10.1093/nar/gkaa1100
  \item Andrew Nightingale, Ricardo Antunes, Emanuele Alpi, Borisas
  Bursteinas, Leonardo Gonzales, Wudong Liu, Jie Luo, Guoying Qi, Edd
  Turner, Maria Martin, The Proteins API: accessing key integrated protein
  and genome information, Nucleic Acids Research, Volume 45, Issue W1,
  3 July 2017, Pages W539–W544, https://doi.org/10.1093/nar/gkx237
  \item \href{https://www.ebi.ac.uk/proteins/api/doc/}{Proteins API
  Documentation}
  \item \href{https://www.uniprot.org/help/publications}{Citations note
  on UniProt website}
  }
}
\seealso{
Other "UniProt - Coordinates": 
\code{\link{rba_uniprot_coordinates}()},
\code{\link{rba_uniprot_coordinates_location}()},
\code{\link{rba_uniprot_coordinates_search}()}
}
\concept{"UniProt - Coordinates"}
