% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/jaspar.R
\name{rba_jaspar_matrix}
\alias{rba_jaspar_matrix}
\title{Get a Position Frequency Matrices (PFM) with annotations}
\usage{
rba_jaspar_matrix(matrix_id, file_format = NULL, save_to = NULL, ...)
}
\arguments{
\item{matrix_id}{Character: A matrix profile
Identifier. It has "base_id.version" naming schema.}

\item{file_format}{Character: Instead of returning a R object, you
can directly download the profile matrix in file with this format.
Supported formats are: "yaml", "jaspar", "transfac", "meme" and "pfm"}

\item{save_to}{NULL or Character:\itemize{
\item NULL: (only if file_format was supplied) Save the file to an
  automatically-generated path.
\item Character string: A valid file or directory path to save the file to.}}

\item{...}{rbioapi option(s). See \code{\link{rba_options}}'s
arguments manual for more information on available options.}
}
\value{
A list that contains the PFM along with its details and
  annotations. If file_format was supplied, an un-parsed character string
  with the file's content.
}
\description{
Using this function you can retrieve a Position Frequency Matrices (PFM)
 associated with a matrix profile Identifier along with its details and
 annotations. If a base ID (i.e. without version suffix) was supplied,
 the latest version will be returned.
}
\section{Corresponding API Resources}{

 "GET "https://jaspar.genereg.net/api/v1/matrix/{matrix_id}/"
}

\examples{
\donttest{
rba_jaspar_matrix("MA0600.2")
}
\dontrun{
rba_jaspar_matrix(matrix_id = "MA0600.2",
                  file_format = "meme",
                  save_to = "my_matrix.meme")
}

}
\references{
\itemize{
  \item Jaime A Castro-Mondragon, Rafael Riudavets-Puig, Ieva
  Rauluseviciute, Roza Berhanu Lemma, Laura Turchi, Romain Blanc-Mathieu,
  Jeremy Lucas, Paul Boddie, Aziz Khan, Nicolás Manosalva Pérez, Oriol
  Fornes, Tiffany Y Leung, Alejandro Aguirre, Fayrouz Hammal, Daniel
  Schmelter, Damir Baranasic, Benoit Ballester, Albin Sandelin, Boris
  Lenhard, Klaas Vandepoele, Wyeth W Wasserman, François Parcy,
  Anthony Mathelier, JASPAR 2022: the 9th release of the open-access
  database of transcription factor binding profiles, Nucleic Acids
  Research, Volume 50, Issue D1, 7 January 2022, Pages D165–D173,
  https://doi.org/10.1093/nar/gkab1113
  \item
  \href{https://jaspar.genereg.net/api/v1/docs/}{JASPAR API Documentation}
  \item \href{https://jaspar.genereg.net/faq/}{Citations note
  on JASPAR website}
  }
}
\seealso{
Other "JASPAR": 
\code{\link{rba_jaspar_collections_matrices}()},
\code{\link{rba_jaspar_collections}()},
\code{\link{rba_jaspar_matrix_search}()},
\code{\link{rba_jaspar_matrix_versions}()},
\code{\link{rba_jaspar_releases}()},
\code{\link{rba_jaspar_sites}()},
\code{\link{rba_jaspar_species_matrices}()},
\code{\link{rba_jaspar_species}()},
\code{\link{rba_jaspar_taxons_matrices}()},
\code{\link{rba_jaspar_taxons}()},
\code{\link{rba_jaspar_tffm_search}()},
\code{\link{rba_jaspar_tffm}()}
}
\concept{"JASPAR"}
