% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/uniprot_proteins.R
\name{rba_uniprot_proteins}
\alias{rba_uniprot_proteins}
\title{Get UniProt entry by accession}
\usage{
rba_uniprot_proteins(accession, interaction = FALSE, isoforms = FALSE, ...)
}
\arguments{
\item{accession}{\href{https://www.uniprot.org/help/accession_numbers}{
UniProtKB primary or secondary accession}.}

\item{interaction}{Logical: (default = FALSE) Only retrieve
\href{https://www.uniprot.org/help/interaction_section}{interaction}
information of your supplied UniProt entity?}

\item{isoforms}{Logical: (default = FALSE) Only retrieve
\href{https://www.uniprot.org/help/alternative_products}{isoforms} of your
supplied UniProt entity?}

\item{...}{rbioapi option(s). See \code{\link{rba_options}}'s
arguments manual for more information on available options.}
}
\value{
A list that contains UniProt protein informations with your
  supplied accession.
}
\description{
Use this function to retrieve a UniProt Entry by it's UniProt accession.
  You can also use "isoform" or "interaction" arguments to retrieve
  isoforms or interactor proteins of that entry. Note that in one function
  call you can only set none or only one of "isoform" or "interaction" as
  TRUE, not both of them.
}
\section{Corresponding API Resources}{

 "GET https://ebi.ac.uk/proteins/api/proteins/{accession}"
 \cr "GET https://ebi.ac.uk/proteins/api/proteins/interaction/{accession}"
 \cr "GET https://ebi.ac.uk/proteins/api/proteins/{accession}/isoforms"
}

\examples{
\donttest{
rba_uniprot_proteins(accession = "P01730")
}
\donttest{
rba_uniprot_proteins(accession = "P01730", interaction = TRUE)
}
\donttest{
rba_uniprot_proteins(accession = "Q29983", isoforms = TRUE)
}

}
\references{
\itemize{
  \item Andrew Nightingale, Ricardo Antunes, Emanuele Alpi, Borisas
  Bursteinas, Leonardo Gonzales, Wudong Liu, Jie Luo, Guoying Qi, Edd
  Turner, Maria Martin, The Proteins API: accessing key integrated protein
  and genome information, Nucleic Acids Research, Volume 45, Issue W1,
  3 July 2017, Pages W539–W544, https://doi.org/10.1093/nar/gkx237
  \item \href{https://www.ebi.ac.uk/proteins/api/doc/}{Proteins API
  Documentation}
  }
}
\seealso{
Other "UniProt - Proteins": 
\code{\link{rba_uniprot_proteins_crossref}()},
\code{\link{rba_uniprot_proteins_search}()}
}
\concept{"UniProt - Proteins"}
