% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/random.R
\name{bedrock_random_create_seed}
\alias{bedrock_random_create_seed}
\title{Random Number Seeds for Minecraft}
\usage{
bedrock_random_create_seed(x, z, a, b, salt, type)
}
\arguments{
\item{x, z}{chunk coordinates}

\item{a, b}{seed parameters}

\item{salt}{seed parameter}

\item{type}{which seed type to use}
}
\description{
Minecraft uses several different kind of seeds during world generation and
gameplay.
}
\details{
\code{bedrock_random_create_seed()} constructs a seed using the formulas
type 1: \code{x*a ^ z*b ^ salt}, type 2: \code{x*a + z*b + salt}, and type 3:
\code{x*a + z*b ^ salt}.
}
\examples{
# identify slime chunks
g <- expand.grid(x=1:10, z=1:10)
is_slime_chunk <- mapply(g$x, g$z, FUN = function(x,z) {
  seed <- bedrock_random_create_seed(x,z,0x1f1f1f1f,1,0,type=1)
  bedrock_random_seed(seed)
  bedrock_random_get_uint(1,10) == 0
})

}
