% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/chunk_version.R
\name{ChunkVersion}
\alias{ChunkVersion}
\alias{get_chunk_version_data}
\alias{get_chunk_version_value}
\alias{put_chunk_version_data}
\alias{put_chunk_version_values}
\alias{put_chunk_version_value}
\alias{read_chunk_version_value}
\alias{write_chunk_version_value}
\title{Read and write chunk version data}
\usage{
get_chunk_version_data(db, x, z, dimension, include_legacy = TRUE)

get_chunk_version_value(db, x, z, dimension, include_legacy = TRUE)

put_chunk_version_data(db, data)

put_chunk_version_values(db, x, z, dimension, values)

put_chunk_version_value(db, x, z, dimension, value)

read_chunk_version_value(rawdata)

write_chunk_version_value(num)
}
\arguments{
\item{db}{A bedrockdb object.}

\item{x, z, dimension}{Chunk coordinates to extract version data from.
\code{x} can also be a character vector of db keys.}

\item{include_legacy}{If true, \code{ChunkVersionLegacy} tags will be included.}

\item{data}{A named-vector of key-value pairs for Finalization data.}

\item{values}{An integer vector}

\item{value}{A scalar integer vector}

\item{rawdata}{A scalar raw.}

\item{num}{A scalar integer.}
}
\description{
ChunkVersion data (tag 44) and ChunkVersionLegacy data (tag 118)
store the version number of a chunk. In Minecraft version 1.16.100,
chunk version data was moved from tag 118 to tag 44.

\code{get_chunk_version_data()} retrieves chunk versions from a \code{bedrockdb}.
It will silently drop and keys not representing ChunkVersion data.

\code{put_chunk_version_data()}, \code{put_chunk_version_values()}, and
\code{put_chunk_version_value()} store Finalization data into a \code{bedrockdb}.
\code{put_chunk_version_data()} supports writing both ChunkVersion and
ChunkVersionLegacy tags.
\code{put_chunk_version_values()} and \code{put_chunk_version_value()}
only support ChunkVersion tags.

\code{read_chunk_version_value()} decodes ChunkVersion data.

\code{write_chunk_version_value()} encodes ChunkVersion data.
}
