% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/add_shape.R
\name{set_material}
\alias{set_material}
\title{Set Material

Add shape to a mesh}
\usage{
set_material(
  mesh,
  material = NULL,
  id = NULL,
  diffuse = c(0.5, 0.5, 0.5),
  ambient = c(0, 0, 0),
  specular = c(1, 1, 1),
  transmittance = c(1, 1, 1),
  emission = c(0, 0, 0),
  shininess = 10,
  ior = 1,
  dissolve = 1,
  illum = 1,
  texture_location = "",
  normal_texture_location = "",
  specular_texture_location = "",
  ambient_texture_location = "",
  emissive_texture_location = "",
  diffuse_intensity = 1,
  specular_intensity = 1,
  emission_intensity = 1,
  ambient_intensity = 1,
  culling = "back",
  type = "diffuse",
  translucent = TRUE,
  toon_levels = 5,
  toon_outline_width = 0.05,
  toon_outline_color = "black",
  reflection_intensity = 0,
  reflection_sharpness = 0
)
}
\arguments{
\item{mesh}{The target mesh.}

\item{material}{Default `NULL`. You can pass the output of the `material_list()` function
to specify the material, or use the following individual settings.}

\item{id}{Default `NULL`. Either a number specifying the material to change, or a character vector 
matching the material name.}

\item{diffuse}{Default `c(0.5,0.5,0.5)`. The diffuse color.}

\item{ambient}{Default `c(0,0,0)`. The ambient color.}

\item{specular}{Default `c(1,1,1)`. The specular color.}

\item{transmittance}{Default `c(1,1,1)`. The transmittance}

\item{emission}{Default `c(0,0,0)`. The emissive color.}

\item{shininess}{Default `10.0`. The shininess exponent.}

\item{ior}{Default `1.0`. The index of refraction. If this is not equal to `1.0`, the material will be refractive.}

\item{dissolve}{Default `1.0`. The transparency.}

\item{illum}{Default `1.0`. The illumination.}

\item{texture_location}{Default `""`. The diffuse texture location.}

\item{normal_texture_location}{Default `""`. The normal texture location.}

\item{specular_texture_location}{Default `""`. The specular texture location.}

\item{ambient_texture_location}{Default `""`. The ambient texture location.}

\item{emissive_texture_location}{Default `""`. The emissive texture location.}

\item{diffuse_intensity}{Default `1`. The diffuse intensity.}

\item{specular_intensity}{Default `1`. The specular intensity.}

\item{emission_intensity}{Default `1`. The emission intensity.}

\item{ambient_intensity}{Default `1`. The ambient intensity.}

\item{culling}{Default `"back"`. The culling type. Options are `back`, `front`, and `none`.}

\item{type}{Default `"diffuse"`. The shader type. Options include `diffuse`,`phong`,`vertex`, and `color`.}

\item{translucent}{Default `TRUE`. Whether light should transmit through a semi-transparent material.}

\item{toon_levels}{Default `5`. Number of color breaks in the toon shader.}

\item{toon_outline_width}{Default `0.05`. Expansion term for model to specify toon outline width. Note: setting this property via this function currently does not generate outlines. Specify it during object creation.}

\item{toon_outline_color}{Default `black`. Toon outline color. Note: setting this property via this function currently does not color outlines. Specify it during object creation.}

\item{reflection_intensity}{Default `0.0`. Intensity of the reflection of the environment map, if present. This will be ignored if the material is refractive.}

\item{reflection_sharpness}{Default `1.0`. Sharpness of the reflection, where lower values have blurrier reflections. Must be greater than zero and less than one.}
}
\value{
Shape with new material
}
\description{
Set Material

Add shape to a mesh
}
\examples{
\dontshow{
options("cores"=1)
}
#Set the material of an object
\donttest{
generate_cornell_mesh() \%>\% 
 add_shape(set_material(sphere_mesh(position=c(400,555/2,555/2),radius=40), 
                        diffuse="purple", type="phong")) \%>\% 
 add_shape(set_material(sphere_mesh(position=c(555/2,220,555/2),radius=40),
                        dissolve=0.2,culling="none",diffuse="red")) \%>\% 
 add_shape(set_material(sphere_mesh(position=c(155,300,555/2),radius=60), 
                        material = material_list(diffuse="gold", type="phong", 
                                                 ambient="gold", ambient_intensity=0.4))) \%>\% 
 rasterize_scene(light_info=directional_light(direction=c(0.1,0.6,-1)))
 }
}
