% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/objects.R
\name{torus_mesh}
\alias{torus_mesh}
\title{Torus 3D Model}
\usage{
torus_mesh(
  position = c(0, 0, 0),
  scale = c(1, 1, 1),
  angle = c(0, 0, 0),
  pivot_point = c(0, 0, 0),
  order_rotation = c(1, 2, 3),
  radius = 0.5,
  ring_radius = 0.2,
  sides = 36,
  rings = 36,
  material = material_list()
)
}
\arguments{
\item{position}{Default \code{c(0,0,0)}. Position of the mesh.}

\item{scale}{Default \code{c(1,1,1)}. Scale of the mesh. Can also be a single numeric value scaling all axes uniformly.}

\item{angle}{Default \code{c(0,0,0)}. Angle to rotate the mesh.}

\item{pivot_point}{Default \code{c(0,0,0)}. Point around which to rotate the mesh.}

\item{order_rotation}{Default \code{c(1,2,3)}. Order to rotate the axes.}

\item{radius}{Default \code{0.5}. The radius of the torus.}

\item{ring_radius}{Default \code{0.2}. The radius of the ring.}

\item{sides}{Default \code{36}. The number of faces around the ring when triangulating the torus.}

\item{rings}{Default \code{36}. The number of faces around the torus.}

\item{material}{Default \code{material_list()} (default values). Specify the material of the object.}
}
\value{
List describing the mesh.
}
\description{
Torus 3D Model
}
\examples{
if(run_documentation()) {
#Plot a group of tori in the cornell box
generate_cornell_mesh(ceiling = FALSE) |> 
 add_shape(torus_mesh(position=c(555/2,555/3,555/2), angle=c(20,0,45),
                      radius=120, ring_radius = 40,
                      material = material_list(diffuse="dodgerblue4",type="phong",
                                               ambient="dodgerblue4",ambient_intensity=0.2))) |>
 add_shape(torus_mesh(position=c(400,400,555/2), angle=c(20,200,45),radius=80, ring_radius = 30,
                      material=material_list(diffuse="orange",type="phong",
                                             ambient="orange",ambient_intensity=0.2))) |>
 add_shape(torus_mesh(position=c(150,450,555/2), angle=c(60,180,0),radius=40, ring_radius = 20,
                      material=material_list(diffuse="red",type="phong"))) |>
 rasterize_scene(light_info = directional_light(c(0,1,-2)))
}
}
