% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/generate_altitude_overlay.R
\name{generate_altitude_overlay}
\alias{generate_altitude_overlay}
\title{Generate Altitude Overlay}
\usage{
generate_altitude_overlay(
  hillshade,
  heightmap,
  start_transition,
  end_transition = NULL,
  lower = TRUE
)
}
\arguments{
\item{hillshade}{The hillshade to transition into.}

\item{heightmap}{A two-dimensional matrix, where each entry in the matrix is the elevation at that point. All grid points are assumed to be evenly spaced.}

\item{start_transition}{Elevation above which `hillshade` is completely transparent.}

\item{end_transition}{Default `NULL`. Elevation below which `hillshade` is completely opaque. By default, this is equal to `start_transition`.}

\item{lower}{Default `TRUE`. This makes `hillshade` completely opaque below `start_transition`. If
`FALSE`, the direction will be reversed.}
}
\value{
4-layer RGB array representing the semi-transparent hillshade.
}
\description{
Using a hillshade and the height map, generates a semi-transparent hillshade to
layer onto an existing map.
}
\examples{
#Create a bathymetric hillshade
if(rayshader:::run_documentation()) {
water_palette = colorRampPalette(c("darkblue", "dodgerblue", "lightblue"))(200)
bathy_hs = height_shade(montereybay, texture = water_palette)
plot_map(bathy_hs)
}

if(rayshader:::run_documentation()) {
#Set everything below 0m to water palette
montereybay \%>\%
 sphere_shade(zscale=10) \%>\%
 add_overlay(generate_altitude_overlay(bathy_hs, montereybay, 0, 0))  \%>\%
 add_shadow(ray_shade(montereybay,zscale=50),0.3) \%>\%
 plot_map()
}

#Add snow peaks by setting `lower = FALSE`  
snow_palette = "white"
snow_hs = height_shade(montereybay, texture = snow_palette)

if(rayshader:::run_documentation()) {
#Set the snow transition region from 500m to 1200m
montereybay \%>\%
 sphere_shade(zscale=10, texture = "desert") \%>\%
 add_overlay(generate_altitude_overlay(bathy_hs, montereybay, 0, 0))  \%>\%
 add_overlay(generate_altitude_overlay(snow_hs, montereybay, 500, 1200, lower=FALSE))  \%>\%
 add_shadow(ambient_shade(montereybay,zscale=50,maxsearch=100),0) \%>\%
 plot_map()
}
}
