% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/vcg.R
\name{vcg_raycaster}
\alias{vcg_raycaster}
\title{Cast rays to intersect with mesh}
\usage{
vcg_raycaster(
  x,
  ray_origin,
  ray_direction,
  max_distance = Inf,
  both_sides = FALSE
)
}
\arguments{
\item{x}{surface mesh}

\item{ray_origin}{a matrix with 3 rows or a vector of length 3, the positions
of ray origin}

\item{ray_direction}{a matrix with 3 rows or a vector of length 3, the
direction of the ray, will be normalized to length 1}

\item{max_distance}{positive maximum distance to cast the normalized ray;
default is infinity. Any invalid distances (negative, zero, or \code{NA})
will be interpreted as unset.}

\item{both_sides}{whether to inverse the ray (search both positive and
negative ray directions); default is false}
}
\value{
A list of ray casting results: whether any intersection is found,
position and face normal of the intersection, distance of the ray, and the
index of the intersecting face (counted from 1)
}
\description{
Cast rays to intersect with mesh
}
\examples{

library(ravetools)
sphere <- vcg_sphere(normals = FALSE)
sphere$vb[1:3, ] <- sphere$vb[1:3, ] + c(10, 10, 10)
vcg_raycaster(
  x = sphere,
  ray_origin = array(c(0, 0, 0, 1, 0, 0), c(3, 2)),
  ray_direction = c(1, 1, 1)
)

}
