% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/units.R
\name{as_rave_unit}
\alias{as_rave_unit}
\title{Convert numeric number into print-friendly format}
\usage{
as_rave_unit(x, unit, label = "")
}
\arguments{
\item{x}{numeric or numeric vector}

\item{unit}{the unit of \code{x}}

\item{label}{prefix when printing \code{x}}
}
\value{
Still numeric, but print-friendly class
}
\description{
Convert numeric number into print-friendly format
}
\examples{

sp <- as_rave_unit(1024, 'GB', 'Hard-disk space is ')
print(sp, digits = 0)

sp - 12

as.character(sp)

as.numeric(sp)

# Vectorize
sp <- as_rave_unit(c(500,200), 'MB/s', c('Writing: ', 'Reading: '))
print(sp, digits = 0, collapse = '\n')

}
