% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tensor.R
\name{ECoGTensor}
\alias{ECoGTensor}
\title{'iEEG/ECoG' Tensor class inherit from \code{\link{Tensor}}}
\description{
Four-mode tensor (array) especially designed for
'iEEG/ECoG' data. The Dimension names are: \code{Trial},
\code{Frequency}, \code{Time}, and \code{Electrode}.
}
\author{
Zhengjia Wang
}
\section{Super class}{
\code{\link[raveio:Tensor]{raveio::Tensor}} -> \code{ECoGTensor}
}
\section{Methods}{
\subsection{Public methods}{
\itemize{
\item \href{#method-ECoGTensor-flatten}{\code{ECoGTensor$flatten()}}
\item \href{#method-ECoGTensor-new}{\code{ECoGTensor$new()}}
}
}
\if{html}{\out{
<details><summary>Inherited methods</summary>
<ul>
<li><span class="pkg-link" data-pkg="raveio" data-topic="Tensor" data-id=".use_multi_files"><a href='../../raveio/html/Tensor.html#method-Tensor-.use_multi_files'><code>raveio::Tensor$.use_multi_files()</code></a></span></li>
<li><span class="pkg-link" data-pkg="raveio" data-topic="Tensor" data-id="collapse"><a href='../../raveio/html/Tensor.html#method-Tensor-collapse'><code>raveio::Tensor$collapse()</code></a></span></li>
<li><span class="pkg-link" data-pkg="raveio" data-topic="Tensor" data-id="finalize"><a href='../../raveio/html/Tensor.html#method-Tensor-finalize'><code>raveio::Tensor$finalize()</code></a></span></li>
<li><span class="pkg-link" data-pkg="raveio" data-topic="Tensor" data-id="get_data"><a href='../../raveio/html/Tensor.html#method-Tensor-get_data'><code>raveio::Tensor$get_data()</code></a></span></li>
<li><span class="pkg-link" data-pkg="raveio" data-topic="Tensor" data-id="operate"><a href='../../raveio/html/Tensor.html#method-Tensor-operate'><code>raveio::Tensor$operate()</code></a></span></li>
<li><span class="pkg-link" data-pkg="raveio" data-topic="Tensor" data-id="print"><a href='../../raveio/html/Tensor.html#method-Tensor-print'><code>raveio::Tensor$print()</code></a></span></li>
<li><span class="pkg-link" data-pkg="raveio" data-topic="Tensor" data-id="set_data"><a href='../../raveio/html/Tensor.html#method-Tensor-set_data'><code>raveio::Tensor$set_data()</code></a></span></li>
<li><span class="pkg-link" data-pkg="raveio" data-topic="Tensor" data-id="subset"><a href='../../raveio/html/Tensor.html#method-Tensor-subset'><code>raveio::Tensor$subset()</code></a></span></li>
<li><span class="pkg-link" data-pkg="raveio" data-topic="Tensor" data-id="to_swap"><a href='../../raveio/html/Tensor.html#method-Tensor-to_swap'><code>raveio::Tensor$to_swap()</code></a></span></li>
<li><span class="pkg-link" data-pkg="raveio" data-topic="Tensor" data-id="to_swap_now"><a href='../../raveio/html/Tensor.html#method-Tensor-to_swap_now'><code>raveio::Tensor$to_swap_now()</code></a></span></li>
</ul>
</details>
}}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-ECoGTensor-flatten"></a>}}
\if{latex}{\out{\hypertarget{method-ECoGTensor-flatten}{}}}
\subsection{Method \code{flatten()}}{
converts tensor (array) to a table (data frame)
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{ECoGTensor$flatten(include_index = TRUE, value_name = "value")}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{include_index}}{logical, whether to include dimension names}

\item{\code{value_name}}{character, column name of the value}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
a data frame with the dimension names as index columns and
\code{value_name} as value column
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-ECoGTensor-new"></a>}}
\if{latex}{\out{\hypertarget{method-ECoGTensor-new}{}}}
\subsection{Method \code{new()}}{
constructor
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{ECoGTensor$new(
  data,
  dim,
  dimnames,
  varnames,
  hybrid = FALSE,
  swap_file = temp_tensor_file(),
  temporary = TRUE,
  multi_files = FALSE,
  use_index = TRUE,
  ...
)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{data}}{array or vector}

\item{\code{dim}}{dimension of data, mush match with \code{data}}

\item{\code{dimnames}}{list of dimension names, equal length as \code{dim}}

\item{\code{varnames}}{names of \code{dimnames}, recommended names are:
\code{Trial}, \code{Frequency}, \code{Time}, and \code{Electrode}}

\item{\code{hybrid}}{whether to enable hybrid mode to reduce RAM usage}

\item{\code{swap_file}}{if hybrid mode, where to store the data; default
stores in \code{raveio_getopt('tensor_temp_path')}}

\item{\code{temporary}}{whether to clean up the space when exiting R session}

\item{\code{multi_files}}{logical, whether to use multiple files instead of
one giant file to store data}

\item{\code{use_index}}{logical, when \code{multi_files} is true, whether use
index dimension as partition number}

\item{\code{...}}{further passed to \code{\link{Tensor}} constructor}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
an \code{ECoGTensor} instance
}
}
}
