#' Color palette proposed by Okabe and Ito
#'
#' Two color palettes taken from the article "Color Universal Design" by Okabe
# and Ito, https://jfly.uni-koeln.de/color/. The variant
#' `palette_okabeito` contains a gray color, while `palette_okabeito_black`
#' contains black instead.
#' @export
palette_okabeito <- c("#E69F00", "#56B4E9", "#009E73", "#F0E442", "#0072B2",
                      "#D55E00", "#CC79A7", "#999999")

#' @rdname palette_okabeito
#' @export
palette_okabeito_black <- c("#E69F00", "#56B4E9", "#009E73", "#F0E442",
                            "#0072B2", "#D55E00", "#CC79A7", "#000000")

#' Official color palette for ATLAS
#'
#' Official brand colors for Accessible Teaching, Learning, and Assessment
#' Systems.
#' @export
palette_atlas <- c("#9BD3DD", "#F2A900", "#8FD6BD", "#F0EC74", "#165C7D",
                   "#999999")

#' @rdname palette_atlas
#' @export
palette_atlas_black <- c("#9BD3DD", "#F2A900", "#8FD6BD", "#F0EC74", "#165C7D",
                         "#000000")

#' Color palette proposed by Lisa Charlotte Rost
#'
#' A colorblind friendly palette taken from the article [What to consider when
#' visualizing data for colorblind
#' readers](https://blog.datawrapper.de/colorblindness-part2/)
#' @export
palette_lcrost <- c("#193CBC", "#1473AF", "#589ACF", "#89C3EF", "#EA594E",
                    "#E5B039", "#EDE65A", "#999999")

#' @rdname palette_lcrost
#' @export
palette_lcrost_black <- c("#193CBC", "#1473AF", "#589ACF", "#89C3EF", "#EA594E",
                          "#E5B039", "#EDE65A", "#000000")
