% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/startle.r
\name{loadStartleData}
\alias{loadStartleData}
\title{Load Startle Data}
\usage{
loadStartleData(
  auto_import = TRUE,
  data,
  mass,
  addhead,
  addtail,
  metadata,
  correction = TRUE,
  synchronise = FALSE
)
}
\arguments{
\item{auto_import}{An argument with default value TRUE. If set to TRUE it will load all .pasta files from the working directory and merge them apropriately. If set to FALSE, a user must specify group_names.}

\item{data}{An argument used only if auto_import = FALSE. A list. A list containing data frames with data from .pasta files.}

\item{mass}{An argument used only if auto_import = FALSE. A dataframe, in first column are names of animals, second their mass. Names in first column must correspond to the names of the elements in list used as an data argument.}

\item{addhead}{Optional argument. Adds a number of seconds to the duration of the impulse. Acounts for the lag of the animal.}

\item{addtail}{Optional argument. Adds a number of seconds to the duration of the impulse. Acounts for the lag of the animal.}

\item{metadata}{Optional argument. For a custom made pulse protocol.}

\item{correction}{Argument with default value TRUE. If set to TRUE, values will be corrected for the animal mass.}

\item{synchronise}{Argument with default value FALSE. If set to TRUE, timestamps will be corrected based on the synchroniseTime.csv in the working directory.}
}
\value{
A dataframe with all startle data
}
\description{
This function is used for loading and processing all data related to startle experiments. All data generated with PASTA, Platform for Acoustic STArle experiments, should be placed in a single folder. Navigate to this folder, set it as working directory, and call this function. All data will be loaded, processed and assigned to a chosen variable that can be passed on other functions.
}
\examples{
# Creating random experiment data
data <- list("CTR 1" = data.frame(x = seq(1, 210881, by=12), y = runif(17574, min=-30, max=30)),
             "CTR 2" = data.frame(x = seq(1, 210881, by=12), y = runif(17574, min=-30, max=30)),
             "EXP 1" = data.frame(x = seq(1, 210881, by=12), y = runif(17574, min=-30, max=30)),
             "EXP 2" = data.frame(x = seq(1, 210881, by=12), y = runif(17574, min=-30, max=30)))
mass <- data.frame("group" = c("CTR 1", "CTR 2", "EXP 1", "EXP 2"), "mass" = c(300, 350, 280, 330))

# Running an example of loadStartleData with auto_import set to FALSE
df <- loadStartleData(auto_import=FALSE, data = data, mass = mass, addhead=0.1, addtail=1)

}
