% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cormean.R
\name{correlation-tools}
\alias{correlation-tools}
\alias{r2z}
\alias{z2r}
\alias{r2t}
\alias{t2r}
\alias{r2p}
\alias{rconfint}
\alias{compcorr}
\alias{print.compcorr}
\title{Miscellaneous correlation tools}
\usage{
r2z(r)

z2r(z)

r2t(r, n)

t2r(t, n)

r2p(r, n)

rconfint(r, n, alpha = 0.05)

compcorr(r1, r2, n1, n2)

\method{print}{compcorr}(x, ...)
}
\arguments{
\item{r, r1, r2}{Correlation values.}

\item{z}{Z-scores.}

\item{n, n1, n2}{Sample sizes.}

\item{t}{t-scores.}

\item{alpha}{The significance level to use.}

\item{x}{A \code{compcorr} object to print.}

\item{...}{Ignored.}
}
\value{
For \code{r2z()}, \code{z2r}, \code{r2t}, \code{t2r}, and \code{r2p}, 
a numeric vector with the requested transformation applied. 
For \code{rconfint()}, a numeric vector with two values representing 
the lower and upper confidence intervals of the correlation coefficient.
For \code{compcorr()}, a \code{compcorr} object containing
a z and p value for the requested comparison, 
which can be printed with \code{print.compcorr()}.
}
\description{
Helper functions to compute important statistics from correlation coefficients.
}
\section{Functions}{
\itemize{
\item \code{r2z()}: Converts correlation coefficients to z-scores.

\item \code{z2r()}: Converts z-scores to correlation coefficients.

\item \code{r2t()}: Converts correlation coefficients to t-scores.

\item \code{t2r()}: Converts t-scores to correlation coefficients.

\item \code{r2p()}: Computes the two-sided p-value for a given correlation.

\item \code{rconfint()}: Computes confidence intervals for a given correlation coefficient.

\item \code{compcorr()}: Computes the significance of the difference between two correlation coefficients.

\item \code{print(compcorr)}: Computes the significance of the difference between two correlation coefficients.

}}
\examples{
z <- r2z(.5)
r <- z2r(z)
t<-r2t(r,30)
r<-t2r(t,30)
r2p(r,30)
print(rconfint(r,30))
print(compcorr(.5,.7,20,20))
}
\seealso{
\link{cormean}
}
