% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/bottomSet.R
\name{bottomSet}
\alias{bottomSet}
\title{Compute the k-bottom set for a set of intervals}
\usage{
bottomSet(intervals, k)
}
\arguments{
\item{intervals}{data frame (see \link{generateIntervals} for
the required format)}

\item{k}{cutoff for inclusion}
}
\value{
Indices of intervals in the k-bottom set.
}
\description{
Suppose that we select one point from each of a set of n intervals and rank
them.  The k-bottom set is the set of intervals whose points can have a rank
of n + 1 - k or higher.
}
\details{
See section 4.2 of Rising (2021).
}
\examples{
intervals <- data.frame(left = 1:4, right = 1:4 + 0.5)
bottomSet(intervals, 2)
}
\references{
Rising, Justin (2021).  \emph{Uncertainty in Ranking}.  arXiv:2107.03459.
}
