% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/print.sim_results.R
\name{print.sim_results}
\alias{print.sim_results}
\title{Print \code{sim_results} Object}
\usage{
\method{print}{sim_results}(x, ...)
}
\arguments{
\item{x}{\code{sim_results} object; returned by the \code{\link{sim}} function}

\item{...}{further arguments passed to or from other methods; none specified}
}
\value{
\code{sim_results} object is invisibly returned (the \code{x} param)
}
\description{
Print \code{sim_results} Object
}
\examples{
library(terra)

n1_small <- rast(system.file("input_maps/n1_small.tif", package = "rangr"))
K_small <- rast(system.file("input_maps/K_small.tif", package = "rangr"))

sim_data <- initialise(
  n1_map = n1_small,
  K_map = K_small,
  r = log(2),
  rate = 1 / 1e3
)
sim_res <- sim(obj = sim_data, time = 20, burn = 5)
print(sim_res)


}
