% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/K_get_interpolation.R
\name{K_get_interpolation}
\alias{K_get_interpolation}
\title{Prepare Time-Varying Carrying Capacity Maps}
\usage{
K_get_interpolation(K_map, K_time_points = NULL, time = NULL)
}
\arguments{
\item{K_map}{\code{\link[terra:SpatRaster-class]{SpatRaster}} object with
carrying capacity maps for each \code{K_time_points}}

\item{K_time_points}{integer vector; time for each layer in \code{K_map}, should
contain unique values}

\item{time}{integer vector of length 1; number of total time steps required
(this is defined when evoking the function \code{\link{sim}}).}
}
\value{
\code{\link[terra:SpatRaster-class]{SpatRaster}} object with number of layers
equal to \code{time}.
}
\description{
This function linearly interpolates values in a series of carrying
capacity maps.
}
\details{
To simulate dynamic environmental scenarios (e.g. climate change, land use
change, ecological disturbance, etc.) one needs to provide time-varying
carrying capacity maps.

Either \code{K_time_points} or the \code{time} parameter is needed to perform
interpolation. If the interpolation should be calculated between two carrying
capacity maps, there is no need to pass the time points, because 1 will
be set as the starting time point and \code{time} will be used as the ending point.
On the other hand, in the absence of the \code{time} argument, the maximum element
of \code{K_time_points} is considered to be the ending point for the interpolation.
}
\examples{

# data preparation
library(terra)

n1_small <- rast(system.file("input_maps/n1_small.tif", package = "rangr"))
K_small_changing <- rast(system.file("input_maps/K_small_changing.tif",
package = "rangr"))

K_interpolated_01 <- K_get_interpolation(
  K_small_changing,
  K_time_points = c(1, 10, 15)
)

K_two_layers <- subset(
  K_small_changing,
  c(1, 2)
)
K_interpolated_02 <- K_get_interpolation(
  K_two_layers,
  time = 15
)


}
