% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/getExtentOfList.R
\name{getExtentOfList}
\alias{getExtentOfList}
\title{Get extent of list of SpatialPolygons}
\usage{
getExtentOfList(shapes)
}
\arguments{
\item{shapes}{a list of SpatialPolygons}
}
\value{
an object of class extent
}
\description{
Returns the extent that encompasses all SpatialPolygons in a list
}
\examples{

data(crotalus)

# create some polygons, in this case convex hulls
sp <- split(crotalus, crotalus$genSp)
sp <- lapply(sp, function(x) x[,c('decimallongitude','decimallatitude')])
sp <- lapply(sp, function(x) x[chull(x),])
poly <- lapply(sp, function(x) 
	SpatialPolygons(list(Polygons(list(Polygon(x)), ID = 1))))

getExtentOfList(poly)

}
\author{
Pascal Title
}
